var NAVTREE =
[
  [ "VampPluginSDK", "index.html", [
    [ "Vamp Plugin SDK", "index.html", null ],
    [ "Class List", "annotated.html", [
      [ "_VampFeature", "struct__VampFeature.html", null ],
      [ "_VampFeatureList", "struct__VampFeatureList.html", null ],
      [ "_VampFeatureUnion", "union__VampFeatureUnion.html", null ],
      [ "_VampFeatureV2", "struct__VampFeatureV2.html", null ],
      [ "_VampOutputDescriptor", "struct__VampOutputDescriptor.html", null ],
      [ "_VampParameterDescriptor", "struct__VampParameterDescriptor.html", null ],
      [ "_VampPluginDescriptor", "struct__VampPluginDescriptor.html", null ],
      [ "AmplitudeFollower", "classAmplitudeFollower.html", null ],
      [ "FixedTempoEstimator::D", "classFixedTempoEstimator_1_1D.html", null ],
      [ "Vamp::Plugin::Feature", "structVamp_1_1Plugin_1_1Feature.html", null ],
      [ "FixedTempoEstimator", "classFixedTempoEstimator.html", null ],
      [ "Vamp::Plugin::OutputDescriptor", "structVamp_1_1Plugin_1_1OutputDescriptor.html", null ],
      [ "Vamp::PluginBase::ParameterDescriptor", "structVamp_1_1PluginBase_1_1ParameterDescriptor.html", null ],
      [ "PercussionOnsetDetector", "classPercussionOnsetDetector.html", null ],
      [ "Vamp::Plugin", "classVamp_1_1Plugin.html", null ],
      [ "Vamp::PluginAdapter< P >", "classVamp_1_1PluginAdapter.html", null ],
      [ "Vamp::PluginAdapterBase", "classVamp_1_1PluginAdapterBase.html", null ],
      [ "Vamp::PluginBase", "classVamp_1_1PluginBase.html", null ],
      [ "Vamp::HostExt::PluginBufferingAdapter", "classVamp_1_1HostExt_1_1PluginBufferingAdapter.html", null ],
      [ "Vamp::HostExt::PluginChannelAdapter", "classVamp_1_1HostExt_1_1PluginChannelAdapter.html", null ],
      [ "Vamp::PluginHostAdapter", "classVamp_1_1PluginHostAdapter.html", null ],
      [ "Vamp::HostExt::PluginInputDomainAdapter", "classVamp_1_1HostExt_1_1PluginInputDomainAdapter.html", null ],
      [ "Vamp::HostExt::PluginLoader", "classVamp_1_1HostExt_1_1PluginLoader.html", null ],
      [ "Vamp::HostExt::PluginSummarisingAdapter", "classVamp_1_1HostExt_1_1PluginSummarisingAdapter.html", null ],
      [ "Vamp::HostExt::PluginWrapper", "classVamp_1_1HostExt_1_1PluginWrapper.html", null ],
      [ "PowerSpectrum", "classPowerSpectrum.html", null ],
      [ "Vamp::RealTime", "structVamp_1_1RealTime.html", null ],
      [ "SpectralCentroid", "classSpectralCentroid.html", null ],
      [ "ZeroCrossing", "classZeroCrossing.html", null ]
    ] ],
    [ "Class Index", "classes.html", null ],
    [ "Class Hierarchy", "hierarchy.html", [
      [ "_VampFeature", "struct__VampFeature.html", null ],
      [ "_VampFeatureList", "struct__VampFeatureList.html", null ],
      [ "_VampFeatureUnion", "union__VampFeatureUnion.html", null ],
      [ "_VampFeatureV2", "struct__VampFeatureV2.html", null ],
      [ "_VampOutputDescriptor", "struct__VampOutputDescriptor.html", null ],
      [ "_VampParameterDescriptor", "struct__VampParameterDescriptor.html", null ],
      [ "_VampPluginDescriptor", "struct__VampPluginDescriptor.html", null ],
      [ "FixedTempoEstimator::D", "classFixedTempoEstimator_1_1D.html", null ],
      [ "Vamp::Plugin::Feature", "structVamp_1_1Plugin_1_1Feature.html", null ],
      [ "Vamp::Plugin::OutputDescriptor", "structVamp_1_1Plugin_1_1OutputDescriptor.html", null ],
      [ "Vamp::PluginBase::ParameterDescriptor", "structVamp_1_1PluginBase_1_1ParameterDescriptor.html", null ],
      [ "Vamp::PluginAdapterBase", "classVamp_1_1PluginAdapterBase.html", [
        [ "Vamp::PluginAdapter< P >", "classVamp_1_1PluginAdapter.html", null ]
      ] ],
      [ "Vamp::PluginBase", "classVamp_1_1PluginBase.html", [
        [ "Vamp::Plugin", "classVamp_1_1Plugin.html", [
          [ "AmplitudeFollower", "classAmplitudeFollower.html", null ],
          [ "FixedTempoEstimator", "classFixedTempoEstimator.html", null ],
          [ "PercussionOnsetDetector", "classPercussionOnsetDetector.html", null ],
          [ "PowerSpectrum", "classPowerSpectrum.html", null ],
          [ "SpectralCentroid", "classSpectralCentroid.html", null ],
          [ "Vamp::HostExt::PluginWrapper", "classVamp_1_1HostExt_1_1PluginWrapper.html", [
            [ "Vamp::HostExt::PluginBufferingAdapter", "classVamp_1_1HostExt_1_1PluginBufferingAdapter.html", null ],
            [ "Vamp::HostExt::PluginChannelAdapter", "classVamp_1_1HostExt_1_1PluginChannelAdapter.html", null ],
            [ "Vamp::HostExt::PluginInputDomainAdapter", "classVamp_1_1HostExt_1_1PluginInputDomainAdapter.html", null ],
            [ "Vamp::HostExt::PluginSummarisingAdapter", "classVamp_1_1HostExt_1_1PluginSummarisingAdapter.html", null ]
          ] ],
          [ "Vamp::PluginHostAdapter", "classVamp_1_1PluginHostAdapter.html", null ],
          [ "ZeroCrossing", "classZeroCrossing.html", null ]
        ] ]
      ] ],
      [ "Vamp::HostExt::PluginLoader", "classVamp_1_1HostExt_1_1PluginLoader.html", null ],
      [ "Vamp::RealTime", "structVamp_1_1RealTime.html", null ]
    ] ],
    [ "Class Members", "functions.html", null ],
    [ "Namespace List", "namespaces.html", [
      [ "Vamp", "namespaceVamp.html", null ],
      [ "Vamp::HostExt", "namespaceVamp_1_1HostExt.html", null ]
    ] ],
    [ "Namespace Members", "namespacemembers.html", null ],
    [ "File List", "files.html", [
      [ "AmplitudeFollower.cpp", "AmplitudeFollower_8cpp.html", null ],
      [ "AmplitudeFollower.h", "AmplitudeFollower_8h.html", null ],
      [ "doc-overview", "doc-overview.html", null ],
      [ "FixedTempoEstimator.cpp", "FixedTempoEstimator_8cpp.html", null ],
      [ "FixedTempoEstimator.h", "FixedTempoEstimator_8h.html", null ],
      [ "hostguard.h", "hostguard_8h.html", null ],
      [ "PercussionOnsetDetector.cpp", "PercussionOnsetDetector_8cpp.html", null ],
      [ "PercussionOnsetDetector.h", "PercussionOnsetDetector_8h.html", null ],
      [ "plugguard.h", "plugguard_8h.html", null ],
      [ "vamp-sdk/Plugin.h", "vamp-sdk_2Plugin_8h.html", null ],
      [ "vamp-hostsdk/Plugin.h", "vamp-hostsdk_2Plugin_8h.html", null ],
      [ "PluginAdapter.h", "PluginAdapter_8h.html", null ],
      [ "vamp-sdk/PluginBase.h", "vamp-sdk_2PluginBase_8h.html", null ],
      [ "vamp-hostsdk/PluginBase.h", "vamp-hostsdk_2PluginBase_8h.html", null ],
      [ "PluginBufferingAdapter.h", "PluginBufferingAdapter_8h.html", null ],
      [ "PluginChannelAdapter.h", "PluginChannelAdapter_8h.html", null ],
      [ "PluginHostAdapter.h", "PluginHostAdapter_8h.html", null ],
      [ "PluginInputDomainAdapter.h", "PluginInputDomainAdapter_8h.html", null ],
      [ "PluginLoader.h", "PluginLoader_8h.html", null ],
      [ "plugins.cpp", "plugins_8cpp.html", null ],
      [ "PluginSummarisingAdapter.h", "PluginSummarisingAdapter_8h.html", null ],
      [ "PluginWrapper.h", "PluginWrapper_8h.html", null ],
      [ "PowerSpectrum.cpp", "PowerSpectrum_8cpp.html", null ],
      [ "PowerSpectrum.h", "PowerSpectrum_8h.html", null ],
      [ "vamp-sdk/RealTime.h", "vamp-sdk_2RealTime_8h.html", null ],
      [ "vamp-hostsdk/RealTime.h", "vamp-hostsdk_2RealTime_8h.html", null ],
      [ "SpectralCentroid.cpp", "SpectralCentroid_8cpp.html", null ],
      [ "SpectralCentroid.h", "SpectralCentroid_8h.html", null ],
      [ "system.h", "system_8h.html", null ],
      [ "vamp-hostsdk.h", "vamp-hostsdk_8h.html", null ],
      [ "vamp-sdk.h", "vamp-sdk_8h.html", null ],
      [ "vamp-simple-host.cpp", "vamp-simple-host_8cpp.html", null ],
      [ "vamp.h", "vamp_8h.html", null ],
      [ "ZeroCrossing.cpp", "ZeroCrossing_8cpp.html", null ],
      [ "ZeroCrossing.h", "ZeroCrossing_8h.html", null ]
    ] ],
    [ "Directories", "dirs.html", [
      [ "examples", "dir_4ec587bfce30b9b784fbf1cea7303b09.html", null ],
      [ "host", "dir_6fbd4b7d3be43d486a3cce3231e92c53.html", null ],
      [ "src", "dir_629e1dda0168f818e2ee3ab23f68039a.html", null ],
      [ "vamp", "dir_09d7d2829940fe46b7bc0eab58bbbc83.html", null ],
      [ "vamp-hostsdk", "dir_878d155c6c7dea35ce3fc23c898c55e3.html", null ],
      [ "vamp-sdk", "dir_fc29d784de6894b015ce0522888485dd.html", null ]
    ] ],
    [ "File Members", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

