/*
 * Copyright (c) 2003, 2007-11 Matteo Frigo
 * Copyright (c) 2003, 2007-11 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Nov 25 07:37:22 EST 2012 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_notw_c.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 8 -name n2fv_8 -with-ostride 2 -include n2f.h -store-multiple 2 */

/*
 * This function contains 26 FP additions, 10 FP multiplications,
 * (or, 16 additions, 0 multiplications, 10 fused multiply/add),
 * 38 stack variables, 1 constants, and 20 memory accesses
 */
#include "n2f.h"

static void n2fv_8(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ri;
	  xo = ro;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(16, is), MAKE_VOLATILE_STRIDE(16, os)) {
	       V T1, T2, Tc, Td, T4, T5, T7, T8;
	       T1 = LD(&(xi[0]), ivs, &(xi[0]));
	       T2 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
	       Tc = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
	       Td = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
	       T4 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
	       T5 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
	       T7 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
	       T8 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
	       {
		    V T3, Tj, Te, Tk, T6, Tm, T9, Tn, Tp, Tl;
		    T3 = VSUB(T1, T2);
		    Tj = VADD(T1, T2);
		    Te = VSUB(Tc, Td);
		    Tk = VADD(Tc, Td);
		    T6 = VSUB(T4, T5);
		    Tm = VADD(T4, T5);
		    T9 = VSUB(T7, T8);
		    Tn = VADD(T7, T8);
		    Tp = VSUB(Tj, Tk);
		    Tl = VADD(Tj, Tk);
		    {
			 V Tq, To, Ta, Tf;
			 Tq = VSUB(Tn, Tm);
			 To = VADD(Tm, Tn);
			 Ta = VADD(T6, T9);
			 Tf = VSUB(T9, T6);
			 {
			      V Tr, Ts, Tt, Tu, Tg, Ti, Tb, Th;
			      Tr = VADD(Tl, To);
			      STM2(&(xo[0]), Tr, ovs, &(xo[0]));
			      Ts = VSUB(Tl, To);
			      STM2(&(xo[8]), Ts, ovs, &(xo[0]));
			      Tt = VFMAI(Tq, Tp);
			      STM2(&(xo[4]), Tt, ovs, &(xo[0]));
			      Tu = VFNMSI(Tq, Tp);
			      STM2(&(xo[12]), Tu, ovs, &(xo[0]));
			      Tg = VFNMS(LDK(KP707106781), Tf, Te);
			      Ti = VFMA(LDK(KP707106781), Tf, Te);
			      Tb = VFMA(LDK(KP707106781), Ta, T3);
			      Th = VFNMS(LDK(KP707106781), Ta, T3);
			      {
				   V Tv, Tw, Tx, Ty;
				   Tv = VFMAI(Ti, Th);
				   STM2(&(xo[6]), Tv, ovs, &(xo[2]));
				   STN2(&(xo[4]), Tt, Tv, ovs);
				   Tw = VFNMSI(Ti, Th);
				   STM2(&(xo[10]), Tw, ovs, &(xo[2]));
				   STN2(&(xo[8]), Ts, Tw, ovs);
				   Tx = VFMAI(Tg, Tb);
				   STM2(&(xo[14]), Tx, ovs, &(xo[2]));
				   STN2(&(xo[12]), Tu, Tx, ovs);
				   Ty = VFNMSI(Tg, Tb);
				   STM2(&(xo[2]), Ty, ovs, &(xo[2]));
				   STN2(&(xo[0]), Tr, Ty, ovs);
			      }
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 8, XSIMD_STRING("n2fv_8"), {16, 0, 10, 0}, &GENUS, 0, 2, 0, 0 };

void XSIMD(codelet_n2fv_8) (planner *p) {
     X(kdft_register) (p, n2fv_8, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_notw_c.native -simd -compact -variables 4 -pipeline-latency 8 -n 8 -name n2fv_8 -with-ostride 2 -include n2f.h -store-multiple 2 */

/*
 * This function contains 26 FP additions, 2 FP multiplications,
 * (or, 26 additions, 2 multiplications, 0 fused multiply/add),
 * 24 stack variables, 1 constants, and 20 memory accesses
 */
#include "n2f.h"

static void n2fv_8(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ri;
	  xo = ro;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(16, is), MAKE_VOLATILE_STRIDE(16, os)) {
	       V T3, Tj, Tf, Tk, Ta, Tn, Tc, Tm, Ts, Tu;
	       {
		    V T1, T2, Td, Te;
		    T1 = LD(&(xi[0]), ivs, &(xi[0]));
		    T2 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T3 = VSUB(T1, T2);
		    Tj = VADD(T1, T2);
		    Td = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    Te = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Tf = VSUB(Td, Te);
		    Tk = VADD(Td, Te);
		    {
			 V T4, T5, T6, T7, T8, T9;
			 T4 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 T5 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
			 T6 = VSUB(T4, T5);
			 T7 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			 T8 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
			 T9 = VSUB(T7, T8);
			 Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
			 Tn = VADD(T7, T8);
			 Tc = VMUL(LDK(KP707106781), VSUB(T9, T6));
			 Tm = VADD(T4, T5);
		    }
	       }
	       {
		    V Tr, Tb, Tg, Tp, Tq, Tt;
		    Tb = VADD(T3, Ta);
		    Tg = VBYI(VSUB(Tc, Tf));
		    Tr = VSUB(Tb, Tg);
		    STM2(&(xo[14]), Tr, ovs, &(xo[2]));
		    Ts = VADD(Tb, Tg);
		    STM2(&(xo[2]), Ts, ovs, &(xo[2]));
		    Tp = VSUB(Tj, Tk);
		    Tq = VBYI(VSUB(Tn, Tm));
		    Tt = VSUB(Tp, Tq);
		    STM2(&(xo[12]), Tt, ovs, &(xo[0]));
		    STN2(&(xo[12]), Tt, Tr, ovs);
		    Tu = VADD(Tp, Tq);
		    STM2(&(xo[4]), Tu, ovs, &(xo[0]));
	       }
	       {
		    V Tv, Th, Ti, Tw;
		    Th = VSUB(T3, Ta);
		    Ti = VBYI(VADD(Tf, Tc));
		    Tv = VSUB(Th, Ti);
		    STM2(&(xo[10]), Tv, ovs, &(xo[2]));
		    Tw = VADD(Th, Ti);
		    STM2(&(xo[6]), Tw, ovs, &(xo[2]));
		    STN2(&(xo[4]), Tu, Tw, ovs);
		    {
			 V Tl, To, Tx, Ty;
			 Tl = VADD(Tj, Tk);
			 To = VADD(Tm, Tn);
			 Tx = VSUB(Tl, To);
			 STM2(&(xo[8]), Tx, ovs, &(xo[0]));
			 STN2(&(xo[8]), Tx, Tv, ovs);
			 Ty = VADD(Tl, To);
			 STM2(&(xo[0]), Ty, ovs, &(xo[0]));
			 STN2(&(xo[0]), Ty, Ts, ovs);
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 8, XSIMD_STRING("n2fv_8"), {26, 2, 0, 0}, &GENUS, 0, 2, 0, 0 };

void XSIMD(codelet_n2fv_8) (planner *p) {
     X(kdft_register) (p, n2fv_8, &desc);
}

#endif				/* HAVE_FMA */
