function [ sol ] = unloc_solver( b, A, param,name )
%UNLOC_SOLVER Solve the minimisation problem using UNLOCBOX toolbox
%
% argmin_x ||x||_1 such that ||Ax-b||_2 < sima_t

if nargin<3, param=struct; end

% set parameters
if ~isfield(param, 'verbose'), param.verbose = 1; end
if ~isfield(param, 'T'), param.T = 256; end
if ~isfield(param, 'sigma'), param.sigma = 1; end
if ~isfield(param, 'max_iter'), param.max_iter = 100; end
if ~isfield(param, 'epsilon'), param.epsilon = 1e-3; end

[b2,f1,f2,param] = small_to_unloc(b,A,param); 

if strcmpi(name, 'Douglas_Rachford')    
    sol=douglas_rachford(b2,f2,f1,param);
elseif strcmpi(name, 'Forward_Backard')    
    sol=forward_backward(b2,f1,f2,param);
elseif strcmpi(name, 'ADMM')  
    opL= @(x) x;
    sol=admm(b2,f1,f2,opL,param);
else
    error('UNLocBox tells you: Unknown solver name!')
end;



end

