function [b2,f1,f2,param] = small_to_unloc(b,A,param)
    

    if nargin<3, param=struct; end
    % set parameters
    if ~isfield(param, 'verbose'), param.verbose = 0; end
    if ~isfield(param, 'T'), param.T = 1; end
    if ~isfield(param, 'gamma'), param.gamma = 1/(1.1*norm(A)^2); end
    if ~isfield(param, 'sigma'), param.sigma = 1; end
    
    
    %set function f2
    param_f2.verbose=param.verbose;
    param_f2.A=@(x) A*x;
    param_f2.At=@(x) A'*x;
    param_f2.y=b;
    param_f2.tight=0;
    param_f2.nu=norm(A,2)^2;
    param_f2.epsilon=param.sigma;
    
    f2.prox= @(x,l) fast_proj_B2(x,l,param_f2); % douglas rachford, admm
    f2.grad= @(x) 2*A'*(A*x-b); %forward backward
    f2.x0=A'*b;
    f2.norm=@(x) 0;
    
    
    
    
    %set function f1
    param_f1.verbose=param.verbose;
    
    f1.x0=A'*b;
    f1.norm= @(x) sum(sum(abs(x)));
    f1.prox= @(x,l) prox_L1(x,param.T*l,param_f1);
    
    
    
    %set initial point
    b2=A'*b;
    
    
end

