function DL = SMALL_learn(Problem,DL)
%%% SMALL Dictionary Learning   
%
%   Centre for Digital Music, Queen Mary, University of London.
%   This file copyright 2009 Ivan Damnjanovic.
%
%   This program is free software; you can redistribute it and/or
%   modify it under the terms of the GNU General Public License as
%   published by the Free Software Foundation; either version 2 of the
%   License, or (at your option) any later version.  See the file
%   COPYING included with this distribution for more information.
%   
%   Function gets as input Problem and Dictionary Learning (DL) structures 
%   In Problem structure field b with the training set needs to be defined
%   In DL fields with name of the toolbox and solver, and parameters file 
%   for particular dictionary learning technique needs to be present.
%
%   Outputs are Learned dictionary and time spent as a part of DL structure
%%
 
  fprintf('\nStarting Dictionary Learning %s... \n', DL.name);
  start=cputime;
  tStart=tic;
  if strcmpi(DL.toolbox,'KSVD')
    param=DL.param; 
    param.data=Problem.b;
 
    D = eval([DL.name,'(param)']);%, ''t'', 5);']);
  elseif strcmpi(DL.toolbox,'KSVDS')
    param=DL.param; 
    param.data=Problem.b;
    
    D = eval([DL.name,'(param, ''t'', 5);']);
  elseif strcmpi(DL.toolbox,'SPAMS')
    
    X  = Problem.b; 
    param=DL.param;
    
    D = eval([DL.name,'(X, param);']);
    %   As some versions of SPAMS does not produce unit norm column
    %   dictionaries, we need to make sure that columns are normalised to
    %   unit lenght.
    
    for i = 1: size(D,2)
        D(:,i)=D(:,i)/norm(D(:,i));
    end
  elseif strcmpi(DL.toolbox,'SMALL')
    
    X  = Problem.b; 
    param=DL.param;
    
    D = eval([DL.name,'(X, param);']);
    %   we need to make sure that columns are normalised to
    %   unit lenght.
    
    for i = 1: size(D,2)
        D(:,i)=D(:,i)/norm(D(:,i));
    end
  elseif  strcmpi(DL.toolbox,'mpv2')
      X = Problem.b(:,1:1:40000);
      jD0 = mpv2.SimpleMatrix(DL.param.D);
      jDicLea = mpv2.DictionaryLearning(jD0, 1,1);
% !!!!! MAYBE lambda is not needed for ILS - NEED TO CHECK!!!!
      jDicLea.setLambda('L', DL.param.lambda, DL.param.lambda, 1000);
       jDicLea.setVerbose(2);
      jDicLea.setORMP(16, 1e-6, DL.param.abs);
      eval(['jDicLea.',DL.name,'( X(:), DL.param.iternum );']);
      jD =  jDicLea.getDictionary();
      
      D = reshape(jD.getAll(), size(X,1), DL.param.K);
      
%   To introduce new dictionary learning technique put the files in
%   your Matlab path. Next, unique name <TolboxID> for your toolbox needs 
%   to be defined and also prefferd API for toolbox functions <Preffered_API>
%   
% elseif strcmpi(DL.toolbox,'<ToolboxID>')
%     % This is an example of API that can be used:
%     % - get training set from Problem part of structure
%     % - assign parameters defined in the main program
%
%     X  = Problem.b; 
%     param=DL.param;
%
%     % - Evaluate the function (DL.name - defined in the main) with
%     %   parameters given above
%
%     D = eval([DL.name,'(<Preffered_API>);']);

  else
    printf('\nToolbox has not been registered. Please change SMALL_learn file.\n');
    return
  end
  
%%
%   Dictionary Learning time
tElapsed=toc(tStart);
  DL.time = cputime - start;
  fprintf('\n%s finished task in %2f seconds. \n', DL.name, DL.time);
  fprintf('\n%s finished task in %2f seconds. \n', DL.name, tElapsed);
DL.time=tElapsed;
%   If dictionary is given as a sparse matrix change it to full  

  DL.D = full(D);
  
end
  