function solver = SMALL_solve(Problem, solver)
%%% SMALL sparse solver
%   Ivan Damnjanovic 2009
%   Function gets as input SMALL structure that contains SPARCO problem to
%   be solved, name of the toolbox and solver, and parameters file for
%   particular solver.
%
%   Outputs are solution, reconstructed signal and time spent
%%

if isa(Problem.A,'float')
    A = Problem.A;
    SparseLab_A=Problem.A;
    m = size(Problem.A,1);      % m is the no. of rows.
    n = size(Problem.A,2);      % n is the no. of columns.
else
    A  = @(x) Problem.A(x,1);  % The operator
    AT = @(y) Problem.A(y,2);  % and its transpose.
    SparseLab_A =@(mode, m, n, x, I, dim) SL_A(Problem.A, mode, m, n, x, I, dim);
    m = Problem.sizeA(1);      % m is the no. of rows.
    n = Problem.sizeA(2);      % n is the no. of columns.
    
end
b  = Problem.b;            % The right-hand-side vector.
%%
fprintf('\nStarting solver %s... \n', solver.name);
start=cputime;

if strcmpi(solver.toolbox,'sparselab')
    y = eval([solver.name,'(SparseLab_A, b, n,',solver.param,');']);
elseif strcmpi(solver.toolbox,'sparsify')
    y = eval([solver.name,'(b, A, n, ''P_trans'', AT,',solver.param,');']);
elseif (strcmpi(solver.toolbox,'spgl1')||strcmpi(solver.toolbox,'gpsr'))
    y = eval([solver.name,'(b, A,',solver.param,');']);
elseif (strcmpi(solver.toolbox,'SPAMS'))
    y = eval([solver.name,'(b, A, solver.param);']);
elseif (strcmpi(solver.toolbox,'SMALL'))
    if isa(Problem.A,'float')
        y = eval([solver.name,'(A, b, n,',solver.param,');']);
    else
        y = eval([solver.name,'(A, b, n,',solver.param,',AT);']);
    end
    
%   To introduce new sparse representation algorithm put the files in
%   your Matlab path. Next, unique name <TolboxID> for your toolbox and
%   prefferd API <Preffered_API> needs to be defined.
%
% elseif strcmpi(solver.toolbox,'<ToolboxID>')
%
%     % - Evaluate the function (solver.name - defined in the main) with
%     %   parameters given above
%
%     y = eval([solver.name,'(<Preffered_API>);']);

else
    printf('\nToolbox has not been registered. Please change SMALL_solver file.\n');
    return
end

%%
%   Sparse representation time

solver.time = cputime - start;
fprintf('Solver %s finished task in %2f seconds. \n', solver.name, solver.time);

% geting around out of memory problem when converting big matrix from
% sparse to full...

if (Problem.sparse==1)
    solver.solution = y;
else
    solver.solution = full(y);
end

%   Reconstruct the signal from the solution
solver.reconstructed  = Problem.reconstruct(solver.solution);
end
