function SMALL_ImgDeNoiseResult(SMALL)
%   Ivan Damnjanovic 2010
%   Function gets as input SMALL structure and plots  Image Denoise
%   results: Original Image, Noisy Image and for learned dictionaries and 
%   denoised images 


figure('Name', sprintf('Image %s (training set size- %d, sigma - %d)',SMALL.Problem.name, SMALL.Problem.n, SMALL.Problem.sigma));

m=size(SMALL.solver,2)+1;
maxval=SMALL.Problem.maxval;
im=SMALL.Problem.Original;
imnoise=SMALL.Problem.Noisy;

subplot(2, m, 1); imshow(im/maxval);
title('Original image');

subplot(2,m,m+1); imshow(imnoise/maxval);
title(sprintf('Noisy image, PSNR = %.2fdB', 20*log10(maxval * sqrt(numel(im)) / norm(im(:)-imnoise(:))) ));

for i=2:m
    params=SMALL.solver(i-1).param;
    subplot(2, m, i); imshow(SMALL.solver(i-1).reconstructed.Image/maxval);
    title(sprintf('%s Denoised image, PSNR: %.2f dB in %.2f s',...
        SMALL.DL(i-1).name, SMALL.solver(i-1).reconstructed.psnr, SMALL.solver(i-1).time ));
    if strcmpi(SMALL.DL(i-1).name,'ksvds')
        D = kron(SMALL.Problem.basedict{2},SMALL.Problem.basedict{1})*SMALL.DL(i-1).D;
    else
        D = SMALL.DL(i-1).D;
    end
    dictimg = showdict(D,params.blocksize,...
        round(sqrt(size(D,2))),round(sqrt(size(D,2))),'lines','highcontrast');
    
    subplot(2,m,m+i);imshow(imresize(dictimg,2,'nearest'));
    title(sprintf('%s dictionary in %.2f s',...
        SMALL.DL(i-1).name, SMALL.DL(i-1).time));
    
end