function id = diag_ids(x,k)
%DIAG_IDS Indices of matrix diagonal elements.
%  ID = DIAG_IDS(X) returns the indices of the main diagonal of X.
%
%  ID = DIAG_IDS(X,K) returns the indices of the K-th diagonal. K=0
%  represents the main diagonal, positive values are above the main
%  diagonal and negative values are below the main diagonal.


%  Ron Rubinstein
%  Computer Science Department
%  Technion, Haifa 32000 Israel
%  ronrubin@cs
%
%  September 2006


if (nargin==1), k=0; end

[m,n] = size(x);
l = max(m,n);

if (k<=0)
  id = (0:l-1)*m + (1:l) - k;
else
  id = (0:l-1)*m + (1:l) + k*m;
end

if (l-k>m), id = id(1:end-(l-k-m)); end
if (l+k>n), id = id(1:end-(l+k-n)); end
