function SMALL = SMALL_solve(SMALL)
  % Ivan Damnjanovic 2009
  % Function gets as input SMALL structure that contains SPARCO problem to
  % be solved, name of the toolbox and solver, and parameters file for particular solver
  % Outputs are solution, reconstructed signal and time spent
  %%
  
  A  = @(x) SMALL.Problem.A(x,1);  % The operator
  AT = @(y) SMALL.Problem.A(y,2);  % and its transpose.
  b  = SMALL.Problem.b;            % The right-hand-side vector.
  m = SMALL.Problem.sizeA(1);      % m is the no. of rows.
  n = SMALL.Problem.sizeA(2);      % n is the no. of columns.
  
  fprintf('\nStarting solver %s... \n', SMALL.solver.name);
  start=cputime;
  %%
  if strcmpi(SMALL.solver.toolbox,'sparselab')
    y = eval([SMALL.solver.name,'(''SL_A'', b, n,',SMALL.solver.param,');']);
  elseif strcmpi(SMALL.solver.toolbox,'sparsify')
    y = eval([SMALL.solver.name,'(b, A, n, ''P_trans'', AT,',SMALL.solver.param,');']);
  elseif (strcmpi(SMALL.solver.toolbox,'spgl1')||strcmpi(SMALL.solver.toolbox,'gpsr'))
    y = eval([SMALL.solver.name,'(b, A,',SMALL.solver.param,');']);
  else
    y = eval([SMALL.solver.name,'(A, b, n,',SMALL.solver.param,',AT);']);
  end
  %%
  SMALL.solver.time = cputime - start;
  fprintf('Solver %s finished task in %2f seconds. \n', SMALL.solver.name, SMALL.solver.time);
  SMALL.solver.solution = full(y);
  SMALL.solver.reconstructed  = SMALL.Problem.reconstruct(SMALL.solver.solution);
end
  