function data=generateAudioDenoiseProblem(au, trainnum, blocksize, dictsize, overlap, sigma, gain, maxval, initdict);
%%% Audio Denoising Problem
%
%   Centre for Digital Music, Queen Mary, University of London.
%   This file copyright 2010 Ivan Damnjanovic.
%
%   This program is free software; you can redistribute it and/or
%   modify it under the terms of the GNU General Public License as
%   published by the Free Software Foundation; either version 2 of the
%   License, or (at your option) any later version.  See the file
%   COPYING included with this distribution for more information.
%   
% 
%
%   generateAudioDenoiseProblem is part of the SMALLbox and generate a
%   problem for comaprison of Dictionary Learning/Sparse Representation
%   techniques in audio denoising scenario. It is based on KSVD image
%   denoise demo by Ron Rubinstein (see bellow).
%   The fuction takes as an optional input 
%       au - audio samples to be denoised
%       trainnum - number of frames for training 
%       blocksize - 1D frame size (eg 512)
%       dictsize - number of atoms to be trained
%       overlap - ammount of overlaping frames between 0 and 1
%   


disp(' ');
disp('  **********  Denoising Problem  **********');
disp(' ');
disp('  This function reads an audio, adds random Gaussian noise,');
disp('  that can be later denoised by using dictionary learning techniques.');
disp(' ');

FS=filesep;
if ~ exist( 'sigma', 'var' ) || isempty(sigma), sigma = 26.74; end
if ~ exist( 'gain', 'var' ) || isempty(gain), gain = 1.15; end

if ~ exist( 'initdict', 'var' ) || isempty(initdict), initdict = 'odct'; end
if ~ exist( 'overlap', 'var' ) || isempty(overlap), overlap = 15/16; end
%% prompt user for wav file %%
%ask for file name

TMPpath=pwd;
if ~ exist( 'au', 'var' ) || isempty(au)
    [pathstr1, name, ext, versn] = fileparts(which('SMALLboxSetup.m'));
    cd([pathstr1,FS,'data',FS,'audio',FS,'wav']);
    [filename,pathname] = uigetfile({'*.wav;'},'Select a wav file');
    [pathstr, name, ext, versn] = fileparts(filename);
    data.name=name;
    
    au = wavread(filename);
    au = mean(au,2); % turn it into mono.
end;
if ~ exist( 'maxval', 'var' ) || isempty(maxval), maxval = max(au); end

%% generate noisy audio %%

disp(' ');
disp('Generating noisy audio...');
sigma = max(au)/10^(sigma/20); 
n = randn(size(au)) .* sigma;
aunoise = au + n;%  here we can load noise audio if available 
                 %  for example: wavread('icassp06_x.wav');%



%% set parameters %%

x = aunoise;
if ~ exist( 'blocksize', 'var' ) || isempty(blocksize),blocksize = 512;end
if ~ exist( 'dictsize', 'var' ) || isempty(dictsize), dictsize = 2048;end

if ~ exist( 'trainnum', 'var' ) || isempty(trainnum),trainnum = (size(x,1)-blocksize+1);end





p=1;


% 
% msgdelta = 5;
% 
% verbose = 't';
% if (msgdelta <= 0)
%   verbose='';
%   msgdelta = -1;
% end
% 
% 
% % initial dictionary %
% 
if (strcmpi(initdict,'odct'))
    initdict = odctndict(blocksize,dictsize,p);
elseif (strcmpi(initdict,'data'))
    clear initdict;    % causes initialization using random examples
else
    error('Invalid initial dictionary specified.');
end

if exist( 'initdict', 'var' ) 
  initdict = initdict(:,1:dictsize);
end


% noise mode %
% if (isfield(params,'noisemode'))
%   switch lower(params.noisemode)
%     case 'psnr'
%       sigma = maxval / 10^(params.psnr/20);
%     case 'sigma'
%       sigma = params.sigma;
%     otherwise
%       error('Invalid noise mode specified');
%   end
% elseif (isfield(params,'sigma'))
%   sigma = params.sigma;
% elseif (isfield(params,'psnr'))
%   sigma = maxval / 10^(params.psnr/20);
% else
%   error('Noise strength not specified');
% end

% params.Edata = sqrt(prod(blocksize)) * sigma * gain;   % target error for omp
% params.codemode = 'error';
% 
% params.sigma = sigma;
% params.noisemode = 'sigma';
% 
% 
% % make sure test data is not present in params
% if (isfield(params,'testdata'))
%   params = rmfield(params,'testdata');
% end


%%%% create training data %%%


X = buffer( x(1:trainnum),blocksize, overlap*blocksize);

% remove dc in blocks to conserve memory %
% bsize = 2000;
% for i = 1:bsize:size(X,2)
%   blockids = i : min(i+bsize-1,size(X,2));
%   X(:,blockids) = remove_dc(X(:,blockids),'columns');
% end
data.Original = au;
data.Noisy = aunoise;
data.b = X;
data.m = size(X,1);
data.n = size(X,2);
data.p = dictsize;
data.blocksize=blocksize;
data.sigma = sigma;
data.gain = gain;
data.maxval = maxval;
data.initdict= initdict;
data.signalDim=1;
cd(TMPpath);

