#!/usr/bin/env python
# encoding: utf-8
"""
plotSSM.py

A helper util to plot SSMs from different features.
"""

import sys
import os
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec, subplot2grid


class FeatureObj() :
	__slots__ = ['key', 'audio', 'timestamps', 'features']

class SSMObj():
	__slots__ = ['ssm', 'novelty', 'gt']

class pltSSM(object):
	
	def __init__(self, ssm0, ssm1, ssm2, novelty0, novelty1, novelty2, novelty0_smoothed, \
	novelty1_smoothed, novelty2_smoothed, gt, ssm_cleaned, novelty):
		self.gt = gt
		self.ssm0 = ssmO
		self.ssm0_cleaned = ssm0_cleaned
		self.novelty0 = novelty0
		self.novelty0_smoothed = novelty0_smoothed
		self.ssm1 = ssm1
		self.ssm1_cleaned = ssm1_cleaned
		self.novelty1_smoothed = novelty1_smoothed
		self.ssm2 = ssm2
		self.ssm2_cleaned = ssm2_cleaned
		self.novelty2_smoothed = novelty2_smoothed
	
	def img_show(self, ax, img, gt, c):
		ax.vlines(gt, 0, img.shape[0], colors=c)
		ax.imshow(img)
		
	def func_show(self, func, gt, c1, c2):
		ax.vlines(gt, 0, len(func), colors=c1)
		ax.plot(np.linspace(0, len(func)-1, len(func)), func, colors=c2)
		
	def plt_subplots(self, filename):
		plt.tight_layout()
		plt.figure(figsize=(20, 30))
		
		ax = plt.subplot2grid((6,3),(0, 0))
		ax0 = plt.subplot2grid((6,3), (0,0), rowspan=2)
		ax1 = plt.subplot2grid((6,3), (0,1), rowspan=2)
		ax2 = plt.subplot2grid((6,3), (0,2))
		ax3 = plt.subplot2grid((6,3), (1,2))
		ax4 = plt.subplot2grid((6,3), (2,0), rowspan=2)
		ax5 = plt.subplot2grid((6,3), (2,1), rowspan=2)
		ax6 = plt.subplot2grid((6,3), (2, 2))
		ax7 = plt.subplot2grid((6,3), (3, 2))
		ax8 = plt.subplot2grid((6,3), (4,0), rowspan=2)
		ax9 = plt.subplot2grid((6,3), (4,1), rowspan=2)
		ax10 = plt.subplot2grid((6,3), (4, 2))
		ax11 = plt.subplot2grid((6,3), (5, 2))
		
		self.img_show(ax0, self.ssm0, self.gt, color='k')
		self.img_show(ax1, self.ssm0_cleaned, self.gt, color='k')
		self.func_show(ax2, self.novelty0, self.gt, c1='g', c2='r')
		self.func_show(ax3, self.novelty0_smoothed, self.gt, c1='g', c2='r')
		self.img_show(ax4, self.ssm1, self.gt, color='k')
		self.img_show(ax5, self.ssm1_cleaned, self.gt, color='k')
		self.func_show(ax6, self.novelty1, self.gt, c1='g', c2='r')
		self.func_show(ax7, self.novelty1_smoothed, self.gt, c1='g', c2='r')
		self.img_show(ax8, self.ssm2, self.gt, color='k')
		self.img_show(ax9, self.ssm2_cleaned, self.gt, color='k')
		self.func_show(ax10, self.novelty2, self.gt, c1='g', c2='r')
		self.func_show(ax11, self.novelty2_smoothed, self.gt, c1='g', c2='r')
		
		plt.show()
		# plt.savefig(filename)
		
def main():
	
	


if __name__ == '__main__':
	main()

