import numpy as np
from numpy import *
import sys, resource
# import matplotlib.pyplot as plt
import subprocess as sp
import cPickle as pickle

# set this True or False to enable/disable plotting
plot_on = False
# plot_on = True

if plot_on :
	import matplotlib.pyplot as plt
	
class OnsetPlot(object):
	'''This class allows creating a series of plots easily.'''
	
	def __init__(self):
		self.signal_plots = []
		self.marker_plots = []
		self.subplots = {}
		
	def reset(self):
		self.__init__()
		
	def update(self,obj):
		self.signal_plots = obj.signal_plots
		self.marker_plots = obj.marker_plots
		self.subplots = obj.subplots
		
	def add_plot(self,signal,subplot=-1,title=""):
		self.signal_plots.append([signal,subplot,title])
		
	def plot_signal(self,signal,subplot,title):
		axes = self.figure.add_subplot(subplot)		
		axes.plot(signal)
		if title : axes.set_title(title)
		plt.axis('tight')
		self.subplots.update({subplot:(axes,signal)})
		
	def plot_markers(self,markers,symbol,subplot):
		values = zeros(len(markers)) + 1
		axes,signal = self.subplots[subplot]
		axes.plot(markers,np.array(signal)[markers],symbol)
		
	def add_markers(self,markers,symbol="g^",subplot=-1):
		self.marker_plots.append([markers,symbol,subplot])
		
	def show_in_subprocess(self):
		'''Marshal the object into a separate subprocess to fix OS/X issues with threading.'''
		cmd = "python %s" %__file__
		print "executing:", cmd
		proc = sp.Popen(cmd, stdin = sp.PIPE, stdout = sp.PIPE, shell=True)
		pickle.dump(self,proc.stdin)
		result = proc.stdout.readlines()
		for item in result:
			print str(item).strip()
		proc.wait()
		return result
				
	def show(self):
		self.figure = plt.figure(figsize=(15,6))
		num_plots = len(self.signal_plots)
		for i,s in enumerate(self.signal_plots) :
			j = i+1
			if s[1] < 1 :
				s[1] = int("%(num_plots)s1%(j)s" %locals())
			else :
				k = s[1]
				s[1] = int("%(num_plots)s1%(k)s" %locals())
			print "plotting:",s[2]
			s = tuple(s)
			self.plot_signal(*s)
		# plot marketrs on the last subplot
		for m in self.marker_plots :
			if m[2] < 1 or m[2] > num_plots:
				m[2] = int("%(num_plots)s1%(num_plots)s" %locals())
			else :
				k = m[2]
				m[2] = int("%(num_plots)s1%(k)s" %locals())
			m = tuple(m)
			self.plot_markers(*m)
		plt.show(block=True)

# create a module-level instance that can be reused across several files
onset_plot = OnsetPlot()

if __name__ == '__main__':
	obj = pickle.load(sys.stdin)
	onset_plot = OnsetPlot()
	onset_plot.update(obj)
	onset_plot.show()
	
	

