#!/usr/bin/env python
# encoding: utf-8
"""
animate.py

Created by mi tian on 2015-01-21.
Copyright (c) 2015 __MyCompanyName__. All rights reserved.
"""

'''
Animate feature from stored data.
'''
import sys, os
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.animation as animation

data = np.genfromtxt('/Users/mitian/Documents/workspace/data/ph.txt',delimiter=',')

fs, stepSize, blockSize = 44100, 2048, 1024
# feature_time = 6
# feature_window = int(fs / stepSize * feature_time)
# feature_step = int(0.5 * fs / stepSize * feature_time)
# nWindow = int((len(data) - feature_window) / feature_step + 1)
feature_step = 48
nWindow = int(len(data) / feature_step)

def animate(i):
	plt.imshow(data[i*feature_step:(i+1)*feature_step, :].T, cmap='hot', origin='lower')
	plt.title('%d-%d(s)' %(3*i, 3*i+6))

def main():
	
	print nWindow
	
	fig, ax = plt.subplots()
	ani = animation.FuncAnimation(fig, animate, np.arange(nWindow), interval= 3000) 
	plt.show()

if __name__ == '__main__':
	main()

