/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*-  vi:set ts=8 sts=4 sw=4: */

/*
    EasyMercurial

    Based on hgExplorer by Jari Korhonen
    Copyright (c) 2010 Jari Korhonen
    Copyright (c) 2012 Chris Cannam
    Copyright (c) 2012 Queen Mary, University of London

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _HGIGNORE_DIALOG_H_
#define _HGIGNORE_DIALOG_H_

#include <QDialog>

class HgIgnoreDialog : public QDialog
{
    Q_OBJECT

public:
    enum IgnoreType {
	IgnoreNothing,
	IgnoreGivenFilesOnly,
	IgnoreAllFilesOfGivenNames,
	IgnoreAllFilesOfGivenSuffixes,
        IgnoreWholeDirectory
    };

    static IgnoreType confirmIgnore(QWidget *parent,
				    QStringList files,
                                    QStringList suffixes,
                                    QString directory);

private slots:
    void optionToggled(bool);

private:
    HgIgnoreDialog(QWidget *parent,
		   QString title,
		   QString introText,
		   QString question,
		   QStringList options,
		   QString okButtonText);

    QString getOption() const { return m_option; }

    QString m_option;
};

#endif
