"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.recording.properties",
            inherit: "view._",

            options: {
                canHaveBase: true,
                //visInstanceContentHeightMin: 10*15,
                //visInstanceContentHeightMax: 10*15,
                visInstanceContentHeightMin: 9*15,
                visInstanceContentHeightMax: 9*15,
            },

            propertyDefinitions: [
                  //["query", "uri", null, function(fieldValue){return decodeURIComponent(fieldValue.slice(fieldValue.indexOf("uri=") + 4));}, "temp"],
                  [null, "library", null, function(fieldValue){return fieldValue.toUpperCase();}],
                  [null, "title"],
                  [null, "genre", "genres"],
                  [null, "composer", "composers"],
                  [null, "performer", "performers", null, "before-divider"],

                  [null, "_divider_"],

                  [null, "place"],
                  [null, "language", "languages"],
                  ["date", "date"],
              ],

            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _doRenderVisInstanceViewBaseWithKnownComparisonMode: function(visInstanceView, comparisonMode) {
                var properties = visInstanceView.dynamicDerivedVisInstanceDataForBase.attributes.apiResponse;
                var $properties = $.bem.generateBlock("vic-properties");

                // TODO add url to cliopatria under the list (requested by Emmanuoil)
                // http://mirg.city.ac.uk/cp/browse/list_resource?r=URI_OF_RECORDING

                _.each(this.propertyDefinitions, function(propertyDefinition) {
                    var propertyName = propertyDefinition[0];
                    if (propertyName == null) {
                        propertyName = propertyDefinition[1];
                    }

                    if (propertyName == "_divider_") {
                        $properties.append($.bem.generateElement("vic-properties", "property-divider"));
                        return;
                    }

                    var propertyValue = properties[propertyName];
                    var propertyCaption = propertyDefinition[1];
                    if (_.isArray(propertyValue)) {
                        if (propertyValue.length > 1) {
                            propertyCaption = propertyDefinition[2];
                        };
                        propertyValue = propertyValue.join(", ");
                    };

                    if (propertyValue && _.isFunction(propertyDefinition[3])) {
                        propertyValue = propertyDefinition[3](propertyValue);
                    };


                    var $property = $.bem.generateElement("vic-properties", "property");
                    var $propertyFieldCaption = $.bem.generateElement("vic-properties", "property-caption");
                    var $propertyValue = $.bem.generateElement("vic-properties", "property-value");

                    $propertyFieldCaption.text(propertyCaption + ":");
                    $propertyValue.text(propertyValue);

                    $property.append($propertyFieldCaption, $propertyValue);
                    $properties.append($property);

                    if (propertyDefinition[4]) {
                        $property.setMod("vic-properties", "property", "type", propertyDefinition[4])
                    }
                });
                visInstanceView.$content
                    .empty()
                    .append($properties)
                    //.append($linkToRawData)
            }

        });
    });
}, Logger);
