"use strict";

App.addInitializer(function(options){
    var _this = this;
    
    if (!_.isUndefined(options.enableJasmine)) {
        var $document = $(document);
        if (!options.enableJasmine) {
            // turn jasmine on
            $document.bind("keydown", "j", function(event) {
                var url = location.protocol+'//'+location.host+location.pathname;
                if (url.indexOf('?') > -1) {
                    url += '&jasmine';
                } else {
                    url += '?jasmine';
                }
                window.location.href = url;
            });
        } else {
            executeJasmine();
            // turn jasmine off
            $document.bind("keydown", "shift+j", function(event) {
                var url = location.protocol+'//'+location.host+location.pathname;
                
                _.each(["jasmine", "catch"], function(variable) {
                    url = url
                        .replace(new RegExp("\\?" + variable + "[=]?[a-zA-Z%0-9]*&", "g"), "?")
                        .replace(new RegExp("\\?" + variable + "[=]?[a-zA-Z%0-9]*$", "g"), "")
                        .replace(new RegExp("\\&" + variable + "[=]?[a-zA-Z%0-9]*&", "g"), "&")
                        .replace(new RegExp("\\&" + variable + "[=]?[a-zA-Z%0-9]*$", "g"), "");
                });

                url = url
                    .replace(/\?+/, "?")
                    .replace(/\?$/, "");

                window.location.href = url;
            });
        }


        
    }
});
