<?php
namespace Kachkaev\JstmplBundle\Twig;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Twig_Extension;
use Twig_Function_Method;

class JstmplExtension extends Twig_Extension
{
    protected $container;

    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * @inheritdoc
     */
    public function getFunctions()
    {
        $functions = array();

        $mappings = array(
            'tmpl_path'	                    => 'getTmplPath',
        );

        foreach($mappings as $twigFunction => $method) {
            $functions[$twigFunction] = new Twig_Function_Method($this, $method);
        }

        $safeMappings = array(
        );

        foreach($safeMappings as $twigFunction => $method) {
            $functions[$twigFunction] = new Twig_Function_Method($this, $method, array ('is_safe' => array('html')));
        }

        return $functions;
    }

    public function getTokenParsers()
    {
        return array(
            new JstmplTokenParser()
        );
    }

    public function getName()
    {
        return 'TmplExtension';
    }

    public function getTmplPath($name)
    {
        return "/js/tmpl/$name.js";
    }
}
