"use strict";

App.module("ContextModule", function(ContextModule, App, Backbone, Marionette, $, _, Logger) {

    // Define private variables
    var logger = null;

    ContextModule.addInitializer(function(options){

        logger = Logger.get("ContextModule.AppContextManager");
        logger.setLevel(Logger.DEBUG);

        /**
         * AppContextManager saves the given app context into the local storage and restores it
         */
        ContextModule.AppContextManager = Backbone.Marionette.Object.extend({

            /**
             * @memberOf App.ContextModule.AppContextManager
             */
            initialize: function() {
                this.defaultSerializedAppContexts = {
                        "": {
                            stateHistory: {
                                currentSerializedState: {
                                    musicCollectionGrid: {
                                        selectedEntityConfigClientId: "def0",
                                        entityConfigs: [
                                                {clientId: "def0", parameters: {"library": "CHARM", composer: "Mozart"}},
                                                {clientId: "def1", parameters: {"library": "CHARM", composer: "Haydn"}}
                                            ],
                                        viewConfigs: [
                                              {clientId: "def2", parameters: {kind: "list"}},
                                              {clientId: "def3", parameters: {kind: "tonic-histogram"}}
                                            ],
                                    },
                                    musicRecordingGrid: {
                                        viewConfigs: [
                                              {clientId: "def4", parameters: {kind: "properties"}},
                                              {clientId: "def5", parameters: {kind: "midi-pitch-histogram"}},
                                          ],
                                    }
                                }
                            }
                        },
                        "empty": {},
                    };
            },

            /**
             * @memberOf App.ContextModule.AppContextManager
             * @returns {Boolean} true if success, false if there was a problem
             */
            saveToStorage: function(appContext) {
                logger.debug("Saving to storage")
                return App.DataModule.Storage.setObjCache(ContextModule, "context", appContext.serialize());
            },

            /**
             * @memberOf App.ContextModule.AppContextManager
             * @returns {Boolean} true if success, false if there was an error, and a default was restored
             */
            restoreFromStorage: function(appContext, nameOfDefaultIfFailure) {
                logger.debug("Restoring from storage")
                var serializedAppContext = App.DataModule.Storage.getObjCache(ContextModule, "context");
                if (!serializedAppContext) {
                    this.restoreDefault(appContext, nameOfDefaultIfFailure);
                    return false;
                } else {
                    appContext.unserialize(serializedAppContext);
                    return true;
                };
            },

            restoreDefault: function(appContext, nameOfDefault) {
                var name = nameOfDefault;
                if (!name) {
                    name = "";
                }
                logger.debug("Restoring default");
                appContext.unserialize(this.defaultSerializedAppContexts[name]);
            }
        });
    });
}, Logger);
