<?php
namespace DML\MainVisBundle\Command\Views\Geography;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ExtractCountryCodesCommand extends ContainerAwareCommand
{
    protected $sourceRelativePath    = "$/views/geography/parsedPlaces.json";
    protected $countriesRelativePath = "$/views/geography/countries.json";
    protected $result1RelativePath   = "$/views/geography/placeCountryCodes.json";
    protected $result2RelativePath   = "$/views/geography/placeCountryNumericCodes.json";

    protected function configure()
    {
        $this
            ->setName('dml:views:geography:extract-country-codes')
            ->setDescription('Takes country codes from parsedPlaces.json and writes them to placeCountryCodes.json')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln(sprintf("Reading from <comment>%s</comment>", $this->sourceRelativePath));

        $sourcePath = $this->getContainer()->getParameter("kernel.root_dir") . '/../' . $this->sourceRelativePath;
        $parsedPlaces = json_decode(file_get_contents($sourcePath), true);


        $output->writeln(sprintf("Reading from <comment>%s</comment>", $this->countriesRelativePath));

        $countriesPath = $this->getContainer()->getParameter("kernel.root_dir") . '/../' . $this->countriesRelativePath;
        $countries = json_decode(file_get_contents($countriesPath), true);


        $output->write(sprintf("Processing..."));

        $countryNumericCodesByCountryCodes = array();
        foreach ($countries as $country) {
            $countryNumericCodesByCountryCodes[$country[0]] = $country[1];
        }

        $countryCodes = array();
        $countryNumericCodes = array();

        foreach ($parsedPlaces as $palceName => $parsedPlace) {
            if ($parsedPlace && array_key_exists('country_code', $parsedPlace)) {
                $countryCode = strtoupper($parsedPlace['country_code']);
                $countryCodes[$palceName] = $countryCode;
                $countryNumericCodes[$palceName] = $countryNumericCodesByCountryCodes[$countryCode];
            }
        }

        $output->writeln(sprintf(" <comment>%s</comment> -> <comment>%s</comment>", sizeof($parsedPlaces), sizeof($countryCodes)));


        $output->writeln(sprintf("Writing to <comment>%s</comment>", $this->result1RelativePath));

        $encodedResult = json_encode($countryCodes);
        $encodedResult = str_replace(array('","'), array("\",\n\""), $encodedResult);

        $resultPath = $this->getContainer()->getParameter("kernel.root_dir") . '/../' . $this->result1RelativePath;
        file_put_contents($resultPath, $encodedResult);


        $output->writeln(sprintf("Writing to <comment>%s</comment>", $this->result2RelativePath));

        $encodedResult = json_encode($countryNumericCodes);
        $encodedResult = str_replace(array(',"'), array(",\n\""), $encodedResult);

        $resultPath = $this->getContainer()->getParameter("kernel.root_dir") . '/../' . $this->result2RelativePath;
        file_put_contents($resultPath, $encodedResult);

        $output->writeln(sprintf("Done."));
    }
}