"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection.tempo-histogram",
            inherit: "view.collection._histogram",

            defaultConfigParameterValues: {
                tempoMin: 30,
                tempoMax: 300,
                tempoNumBins: 50,
                tempoPeriod: 1,
            },


            // =================================================================
            // config grid header

//            _generateHeaderLabelSuffix: function(headerView) {
//                var labelSuffixParts = [];
//                var viewConfig = headerView.options.config;
//                if (!this.configGridParameterHasDefaultValue(viewConfig, "tempoMin")
//                 || !this.configGridParameterHasDefaultValue(viewConfig, "tempoMax")) {
//                        labelSuffixParts.push(_.str.sprintf(" [%s, %s]",
//                                   this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoMin"),
//                                   this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoMax")
//                               ));
//                     }
//                return labelSuffixParts.join("");
//            },


            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                var result = {
                        "min": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoMin"),
                        "max": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoMax"),
                        //"num_bins": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoNumBins"),
                        //"period": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoPeriod"),
                    };
                return result;
            },
        });
    });
}, Logger);
