"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection.pitch-histogram",
            inherit: "view.collection._histogram",


            defaultConfigParameterValues: {
                weighting: "none",
                pitchMin: 20,
                pitchMax: 100,
                //quant:    5
            },


            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                var result = {
                        "weighting": this.getConfigParameterValueOrDefaultValue(viewConfig, "weighting", true),
                        "min":       this.getConfigParameterValueOrDefaultValue(viewConfig, "pitchMin", true),
                        "max":       this.getConfigParameterValueOrDefaultValue(viewConfig, "pitchMax", true),
                        //"quant":     this.getConfigParameterValueOrDefaultValue(viewConfig, "quant", true),
                    };
                return result;
            },
        });
    });
}, Logger);
