"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.recording.tempo-histogram",
            inherit: "view.recording._histogram",

            defaultConfigParameterValues: {
                tempoMin: 30,
                tempoMax: 300,
                tempoNumBins: 50,
                tempoPeriod: 1,
            },

            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForRecordingPerspectiveRequestParams: function(viewConfig) {
                var result = {
                        "min": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoMin"),
                        "max": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoMax"),
                        //"num_bins": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoNumBins"),
                        //"period": this.getConfigParameterValueOrDefaultValue(viewConfig, "tempoPeriod"),
                };
                return result;
            },
        });
    });




}, Logger);
