"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "entity._default",
            inherit: "entity._",


            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // debug mode

            _mapDerivedVisInstanceDataAttributesToDebugAPIQueryBoxes: function (viewMaster) {
                if (viewMaster.options.overlayPerspectiveId) {
                    return [["top",        "base",    "apiRequestURI", "apiResponse"],
                            ["bottom",     "overlay", "apiRequestURI", "apiResponse"]];
                } else {
                    return [["everywhere", "base",    "apiRequestURI", "apiResponse"]];
                }
            }
        });
    });
}, Logger);
