"use strict";

App.module("MainMenuModule", function (MainMenuModule, App, Backbone, Marionette, $, _, Logger) {

    // Define private variables

    MainMenuModule.MainMenuBarView = Backbone.View.extend({

        options: {
            flashingSpeed: 100,
        },

        el: '.main-menu-bar',

        _$itemHelp: null, _$aHelp: null,
        _$itemUndo: null, _$aUndo: null,
        _$itemRedo: null, _$aRedo: null,
        _$itemShare: null, _$aShare: null,
        _$itemBookmarks: null, _$aBookmarks: null,
        _$itemDownloads: null, _$aDownloads: null,

        initialize: function(options) {
            var _this = this;

            _this.$el.disableSelection();

            // Enable help link
            _this._$itemHelp = _this.$(".main-menu-bar__item_action_help");
            _this._$aHelp = _this._$itemHelp.children().first();
            _this._$itemHelp.setMod("main-menu-bar__item", "state", "enabled");
            _this._$aHelp.click(function(event) {
                App.showHelp();
                event.preventDefault();
                return false;
            });

            // Enable undo / redo links
            _this._$itemUndo = _this.$(".main-menu-bar__item_action_undo");
            _this._$aUndo = _this._$itemUndo.children().first();
            _this._$itemRedo = _this.$(".main-menu-bar__item_action_redo");
            _this._$aRedo = _this._$itemRedo.children().first();

            var stateHistory = App.context.get("stateHistory");
            App.context.get("stateHistory").bind("change", _this.render, _this);

            _this._$aUndo.click(function(event) {
                App.undo();
                event.preventDefault();
            });

            _this._$aRedo.click(function(event) {
                App.redo();
                event.preventDefault();
            });

            // Misc actions
            _this._$itemShare = _this.$(".main-menu-bar__item_action_share");
            _this._$aShare = _this._$itemShare.children().first();
            _this._$itemBookmarks = _this.$(".main-menu-bar__item_action_bookmarks");
            _this._$aBookmarks = _this._$itemBookmarks.children().first();
            _this._$itemDownloads = _this.$(".main-menu-bar__item_action_downloads");
            _this._$aDownloads = _this._$itemDownloads.children().first();

            _this._$aShare.click(function(event) {
                App.showStateSharing();
                event.preventDefault();
            });

            _this._$aBookmarks.click(function(event) {
                App.showStateBookmarks();
                event.preventDefault();
            });

            // Mode changer
            _this._$itemChangeMode = _this.$(".main-menu-bar__item_action_change-mode");
            _this._$aChangeModeToRecordings = _this._$itemChangeMode.children().first();
            _this._$aChangeModeToCollections = _this._$itemChangeMode.children().last();

            _this._$aChangeModeToRecordings.click(function(event) {
                App.context.attributes.state.set("musicRecordingsGridIsShown", true);
                event.preventDefault();
            });
            _this._$aChangeModeToCollections.click(function(event) {
                App.context.attributes.state.set("musicRecordingsGridIsShown", false);
                event.preventDefault();
            });

            _this.render(false, true);
        },

        render: function(deep, instant) {
            var _this = this;
            _this._updateUndoRedo();
            _this._updateModeChanger();
        },

        /**
         * callback
         *          function({bool} interrupted)
         */
        flashItem: function(itemActionToFlash, times, callback) {
            var _this = this;
            var $item = _this.$(".main-menu-bar__item_action_" + itemActionToFlash);
            $item.addClass("main-menu-bar__item_flashing");
            var currentCheckNumber = Math.random();
            $item.data("randomNumberForFlashCheck", currentCheckNumber);
            var timerCounter = times > 1 ? times * 2 - 1 : 1;
            var interval = setInterval(function() {
                if (currentCheckNumber == $item.data("randomNumberForFlashCheck")) {
                    if (timerCounter % 2) {
                        $item.removeClass("main-menu-bar__item_flashing");
                    } else {
                        $item.addClass("main-menu-bar__item_flashing");
                    }
                } else {
                    if (_.isFunction(callback)) {
                        callback.call($item, true);
                    }
                    clearInterval(interval);
                }
                if (!--timerCounter) {
                    if (_.isFunction(callback)) {
                        callback.call($item, false);
                    }
                    clearInterval(interval);
                }
            }, _this.options.flashingSpeed);
        },

        _flashModeChangerThreeTimes: function() {
            var _this = this;
            _this.flashItem("change-mode", 3);
        },

        _updateUndoRedo: function() {
            var _this = this;
            var stateHistory = App.context.get("stateHistory");
            _this._$itemUndo.setMod("main-menu-bar", "item", "state", stateHistory.canUndo() ? "enabled" : false);
            _this._$itemRedo.setMod("main-menu-bar", "item", "state", stateHistory.canRedo() ? "enabled" : false);
        },

        _updateModeChanger: function() {
            var _this = this;
            var state = App.context.get("state");
            var musicRecordingsGridIsShown = !! state.get("musicRecordingsGridIsShown");
            if (_this._cachedMusicRecordingsGridIsShown !== musicRecordingsGridIsShown) {
                _this._$itemChangeMode.setMod("main-menu-bar", "item", "mode", musicRecordingsGridIsShown ? "2collections" : "2recordings");

                if (musicRecordingsGridIsShown) {
                    _this.stopListening(state.get("musicRecordingGrid"));
                    _this.listenTo(state.get("musicCollectionGrid"), "change", _this._flashModeChangerThreeTimes);
                } else {
                    _this.stopListening(state.get("musicCollectionGrid"));
                    _this.listenTo(state.get("musicRecordingGrid"), "change", _this._flashModeChangerThreeTimes);
                }
                _this._cachedMusicRecordingsGridIsShown = musicRecordingsGridIsShown;
            }
        }

    });
}, Logger);