"use strict";

App.module("MainRegionModule", function (MainRegionModule, App, Backbone, Marionette, $, _, Logger) {

    MainRegionModule.ConfigGridView = Backbone.View.extend({

        options: {
            state: null,
            configGrid: null,
            parentState: null,
            parentContainerElement: null
        },

        _cachedConfigGridType: null,

        initialize: function(options) {
            var _this = this;
            _this.options = _.defaults(options || {}, this.options);

            _this._cachedConfigGridType = _this.options.configGrid.getType();
            _this.$el.setMod("config-grid", "type", _this._cachedConfigGridType);

            // Remove the loader and other utility text
            _this.$(".config-grid__utils").empty();

            // Set up the header
            _this._$header =  _this.$(".config-grid__header");
            _this._$header.html($("#config-grid__header_type_" + _this._cachedConfigGridType).text());
            _this._$header.click(function() {
                _this.options.configGrid.set({
                    selectedEntityConfigClientId: null,
                    selectedViewConfigClientId: null
                });
            });

            // Generate a ghost (an object that is shown when the view is being flipped)
            _this.$ghost = _this.$el.clone();

            // Init child views
            _this.cellsView = new MainRegionModule.ConfigGridCellsView({
                state: _this.options.state,
                configGrid: _this.options.configGrid,
                el: _this.$(".config-grid-cells"),
                parentConfigGridView: _this
            });

            _this.entityPanelView = new MainRegionModule.ConfigGridPanelView({
                el: _this.$(".config-grid-panel_dimension_entity"),
                state: _this.options.state,
                configGrid: _this.options.configGrid,
                dimension: "entity",
                parentConfigGridView: _this
            });

            _this.viewPanelView = new MainRegionModule.ConfigGridPanelView({
                el: _this.$(".config-grid-panel_dimension_view"),
                state: _this.options.state,
                configGrid: _this.options.configGrid,
                dimension: "view",
                parentConfigGridView: _this
            });

            _this.cellsView.on("change-positions-of-selected-headers", _.throttle(function(entityHeaderLeft, entityHeaderWidth, viewHeaderTop, viewHeaderHeight) {
                _this.entityPanelView.updateRadiusFixer(entityHeaderLeft, entityHeaderWidth);
                _this.viewPanelView  .updateRadiusFixer(viewHeaderTop, viewHeaderHeight);
            }, 100));
        },

        render: function (deep, instant) {
            var _this = this;

            if (deep) {
                _this.cellsView.render(deep, instant);
                _this.entityPanelView.render(deep, instant);
                _this.viewPanelView.render(deep, instant);
            }
        },

        isVisible: function() {
            return !!this.el.getAttribute("data-active");
        },

        scrollAccordingToSelection: function(deep, instant) {
            this.cellsView.scrollAccordingToSelection(deep, instant);
        },

        ignoreAxisOnNextScroll: function(x, y) {
            this.cellsView._ignoreXOnNextScroll = !!x;
            this.cellsView._ignoreYOnNextScroll = !!y;
        }
    });
}, Logger);