"use strict";

/*
 * Logging is controlled by Logger library. Each module has got its own named logger,
 * the app has its own named logger too (App.logger)
 */
App.addInitializer(function(options){
    // Default log level
    Logger.setLevel(
            // Logger.ERROR
               Logger.WARN
            // Logger.INFO
            // Logger.DEBUG
        );

    // App logger
    App.logger = Logger.get("App");
    App.logger.setLevel(Logger.DEBUG);

    // Replace the default handle of the Logger to prepend time coordinate and the name of the logger
    // Based on a native setHandler in js-logger (time, time diff and logger name are prepended)
    var previousLogTime = null;
    Logger.setHandler(function (originalArguments, context) {
        var hdlr = console.log;
        var messages = Array.prototype.slice.call(originalArguments);

        // Prepend the logger's name to the log message for easy identification.
        if (context.name) {
            messages.unshift(_.str.pad(_.str.sprintf("[%s]", context.name), 25, " ", "right"));
        }
        // Prepend time diff
        var logDate = new Date();
        var logTime = logDate.getTime();
        if (previousLogTime && logTime - previousLogTime < 3000) {
            messages.unshift(_.str.sprintf(" %4d", logTime - previousLogTime ));
        } else {
            messages.unshift("     ");
        }
        messages.unshift(_.str.sprintf("%s.%03d", logDate.toTimeString().slice(0, 8),logTime % 1000));
        previousLogTime = logTime;

        // Delegate through to custom warn/error loggers if present on the console.
        if (context.level === Logger.WARN && console.warn) {
            hdlr = console.warn;
        } else if (context.level === Logger.ERROR && console.error) {
            hdlr = console.error;
        } else if (context.level === Logger.INFO && console.info) {
            hdlr = console.info;
        }

        // Support for IE8+ (and other, slightly more sane environments)
        Function.prototype.apply.call(hdlr, console, messages);
     });

    // Log all errors in code (unless jasmine is on)
    if (!options.enableJasmine) {
        window.onerror = function(message, file, line) {
            App.logger.error("[unhandled]", message, file, line);
        };
    }

});
