(function(){
    
    var localStorageDumps = {};
    jasmine.helpers = {

        dumpStorage: function(dumpName) {
            var realDumpName = _.isString(dumpName) ? dumpName : "";
            localStorageDumps[realDumpName] = {};
            var dump = localStorageDumps[realDumpName];
            for (var i = 0, len = localStorage.length; i < len; ++i) {
                dump[localStorage.key(i)] = localStorage.getItem(localStorage.key(i));
            }
        },
        
        clearStorage: function() {
            localStorage.clear();
        },

        restoreStorageFromDump: function(dumpName) {
            var realDumpName = _.isString(dumpName) ? dumpName : "";
            var localStorageDump = localStorageDumps[realDumpName];
            localStorage.clear();
            if (_.isObject(localStorageDump)) {
                for(var key in localStorageDump) {
                    if (localStorageDump.hasOwnProperty(key)) {
                        localStorage.setItem(key,localStorageDump[key]);
                    }
                }
            }
        }
    };
})();
