// MarionetteJS (Backbone.Marionette)
// ----------------------------------
// v2.3.2
//
// Copyright (c)2015 Derick Bailey, Muted Solutions, LLC.
// Distributed under MIT license
//
// http://marionettejs.com


/*!
 * Includes BabySitter
 * https://github.com/marionettejs/backbone.babysitter/
 *
 * Includes Wreqr
 * https://github.com/marionettejs/backbone.wreqr/
 */


(function(e,t){if("function"==typeof define&&define.amd)define(["backbone","underscore"],function(i,n){return e.Marionette=e.Mn=t(e,i,n)});else if("undefined"!=typeof exports){var i=require("backbone"),n=require("underscore");module.exports=t(e,i,n)}else e.Marionette=e.Mn=t(e,e.Backbone,e._)})(this,function(e,t,i){"use strict";(function(e,t){var i=e.ChildViewContainer;return e.ChildViewContainer=function(e,t){var i=function(e){this._views={},this._indexByModel={},this._indexByCustom={},this._updateLength(),t.each(e,this.add,this)};t.extend(i.prototype,{add:function(e,t){var i=e.cid;return this._views[i]=e,e.model&&(this._indexByModel[e.model.cid]=i),t&&(this._indexByCustom[t]=i),this._updateLength(),this},findByModel:function(e){return this.findByModelCid(e.cid)},findByModelCid:function(e){var t=this._indexByModel[e];return this.findByCid(t)},findByCustom:function(e){var t=this._indexByCustom[e];return this.findByCid(t)},findByIndex:function(e){return t.values(this._views)[e]},findByCid:function(e){return this._views[e]},remove:function(e){var i=e.cid;return e.model&&delete this._indexByModel[e.model.cid],t.any(this._indexByCustom,function(e,t){return e===i?(delete this._indexByCustom[t],!0):void 0},this),delete this._views[i],this._updateLength(),this},call:function(e){this.apply(e,t.tail(arguments))},apply:function(e,i){t.each(this._views,function(n){t.isFunction(n[e])&&n[e].apply(n,i||[])})},_updateLength:function(){this.length=t.size(this._views)}});var n=["forEach","each","map","find","detect","filter","select","reject","every","all","some","any","include","contains","invoke","toArray","first","initial","rest","last","without","isEmpty","pluck"];return t.each(n,function(e){i.prototype[e]=function(){var i=t.values(this._views),n=[i].concat(t.toArray(arguments));return t[e].apply(t,n)}}),i}(e,t),e.ChildViewContainer.VERSION="0.1.5",e.ChildViewContainer.noConflict=function(){return e.ChildViewContainer=i,this},e.ChildViewContainer})(t,i),function(e,t){var i=e.Wreqr,n=e.Wreqr={};return e.Wreqr.VERSION="1.3.1",e.Wreqr.noConflict=function(){return e.Wreqr=i,this},n.Handlers=function(e,t){var i=function(e){this.options=e,this._wreqrHandlers={},t.isFunction(this.initialize)&&this.initialize(e)};return i.extend=e.Model.extend,t.extend(i.prototype,e.Events,{setHandlers:function(e){t.each(e,function(e,i){var n=null;t.isObject(e)&&!t.isFunction(e)&&(n=e.context,e=e.callback),this.setHandler(i,e,n)},this)},setHandler:function(e,t,i){var n={callback:t,context:i};this._wreqrHandlers[e]=n,this.trigger("handler:add",e,t,i)},hasHandler:function(e){return!!this._wreqrHandlers[e]},getHandler:function(e){var t=this._wreqrHandlers[e];if(t)return function(){var e=Array.prototype.slice.apply(arguments);return t.callback.apply(t.context,e)}},removeHandler:function(e){delete this._wreqrHandlers[e]},removeAllHandlers:function(){this._wreqrHandlers={}}}),i}(e,t),n.CommandStorage=function(){var i=function(e){this.options=e,this._commands={},t.isFunction(this.initialize)&&this.initialize(e)};return t.extend(i.prototype,e.Events,{getCommands:function(e){var t=this._commands[e];return t||(t={command:e,instances:[]},this._commands[e]=t),t},addCommand:function(e,t){var i=this.getCommands(e);i.instances.push(t)},clearCommands:function(e){var t=this.getCommands(e);t.instances=[]}}),i}(),n.Commands=function(e){return e.Handlers.extend({storageType:e.CommandStorage,constructor:function(t){this.options=t||{},this._initializeStorage(this.options),this.on("handler:add",this._executeCommands,this);var i=Array.prototype.slice.call(arguments);e.Handlers.prototype.constructor.apply(this,i)},execute:function(e,t){e=arguments[0],t=Array.prototype.slice.call(arguments,1),this.hasHandler(e)?this.getHandler(e).apply(this,t):this.storage.addCommand(e,t)},_executeCommands:function(e,i,n){var r=this.storage.getCommands(e);t.each(r.instances,function(e){i.apply(n,e)}),this.storage.clearCommands(e)},_initializeStorage:function(e){var i,n=e.storageType||this.storageType;i=t.isFunction(n)?new n:n,this.storage=i}})}(n),n.RequestResponse=function(e){return e.Handlers.extend({request:function(){var e=arguments[0],t=Array.prototype.slice.call(arguments,1);return this.hasHandler(e)?this.getHandler(e).apply(this,t):void 0}})}(n),n.EventAggregator=function(e,t){var i=function(){};return i.extend=e.Model.extend,t.extend(i.prototype,e.Events),i}(e,t),n.Channel=function(){var i=function(t){this.vent=new e.Wreqr.EventAggregator,this.reqres=new e.Wreqr.RequestResponse,this.commands=new e.Wreqr.Commands,this.channelName=t};return t.extend(i.prototype,{reset:function(){return this.vent.off(),this.vent.stopListening(),this.reqres.removeAllHandlers(),this.commands.removeAllHandlers(),this},connectEvents:function(e,t){return this._connect("vent",e,t),this},connectCommands:function(e,t){return this._connect("commands",e,t),this},connectRequests:function(e,t){return this._connect("reqres",e,t),this},_connect:function(e,i,n){if(i){n=n||this;var r="vent"===e?"on":"setHandler";t.each(i,function(i,s){this[e][r](s,t.bind(i,n))},this)}}}),i}(n),n.radio=function(e){var i=function(){this._channels={},this.vent={},this.commands={},this.reqres={},this._proxyMethods()};t.extend(i.prototype,{channel:function(e){if(!e)throw Error("Channel must receive a name");return this._getChannel(e)},_getChannel:function(t){var i=this._channels[t];return i||(i=new e.Channel(t),this._channels[t]=i),i},_proxyMethods:function(){t.each(["vent","commands","reqres"],function(e){t.each(n[e],function(t){this[e][t]=r(this,e,t)},this)},this)}});var n={vent:["on","off","trigger","once","stopListening","listenTo","listenToOnce"],commands:["execute","setHandler","setHandlers","removeHandler","removeAllHandlers"],reqres:["request","setHandler","setHandlers","removeHandler","removeAllHandlers"]},r=function(e,t,i){return function(n){var r=e._getChannel(n)[t],s=Array.prototype.slice.call(arguments,1);return r[i].apply(r,s)}};return new i}(n),e.Wreqr}(t,i);var n=e.Marionette,r=t.Marionette={};r.VERSION="2.3.2",r.noConflict=function(){return e.Marionette=n,this},t.Marionette=r,r.Deferred=t.$.Deferred,r.extend=t.Model.extend,r.isNodeAttached=function(e){return t.$.contains(document.documentElement,e)},r.getOption=function(e,t){return e&&t?e.options&&void 0!==e.options[t]?e.options[t]:e[t]:void 0},r.proxyGetOption=function(e){return r.getOption(this,e)},r._getValue=function(e,t,n){return i.isFunction(e)&&(n=n||[],e=e.apply(t,n)),e},r.normalizeMethods=function(e){return i.reduce(e,function(e,t,n){return i.isFunction(t)||(t=this[t]),t&&(e[n]=t),e},{},this)},r.normalizeUIString=function(e,t){return e.replace(/@ui\.[a-zA-Z_$0-9]*/g,function(e){return t[e.slice(4)]})},r.normalizeUIKeys=function(e,t){return i.reduce(e,function(e,i,n){var s=r.normalizeUIString(n,t);return e[s]=i,e},{})},r.normalizeUIValues=function(e,t){return i.each(e,function(n,s){i.isString(n)&&(e[s]=r.normalizeUIString(n,t))}),e},r.actAsCollection=function(e,t){var n=["forEach","each","map","find","detect","filter","select","reject","every","all","some","any","include","contains","invoke","toArray","first","initial","rest","last","without","isEmpty","pluck"];i.each(n,function(n){e[n]=function(){var e=i.values(i.result(this,t)),r=[e].concat(i.toArray(arguments));return i[n].apply(i,r)}})};var s=r.deprecate=function(e,t){i.isObject(e)&&(e=e.prev+" is going to be removed in the future. "+"Please use "+e.next+" instead."+(e.url?" See: "+e.url:"")),void 0!==t&&t||s._cache[e]||(s._warn("Deprecation warning: "+e),s._cache[e]=!0)};s._warn="undefined"!=typeof console&&(console.warn||console.log)||function(){},s._cache={},r._triggerMethod=function(){function e(e,t,i){return i.toUpperCase()}var t=/(^|:)(\w)/gi;return function(n,r,s){var o=3>arguments.length;o&&(s=r,r=s[0]);var h,a="on"+r.replace(t,e),l=n[a];return i.isFunction(l)&&(h=l.apply(n,o?i.rest(s):s)),i.isFunction(n.trigger)&&(o+s.length>1?n.trigger.apply(n,o?s:[r].concat(i.rest(s,0))):n.trigger(r)),h}}(),r.triggerMethod=function(){return r._triggerMethod(this,arguments)},r.triggerMethodOn=function(e){var t=i.isFunction(e.triggerMethod)?e.triggerMethod:r.triggerMethod;return t.apply(e,i.rest(arguments))},r.MonitorDOMRefresh=function(e){function t(){e._isShown=!0,s()}function n(){e._isRendered=!0,s()}function s(){e._isShown&&e._isRendered&&r.isNodeAttached(e.el)&&i.isFunction(e.triggerMethod)&&e.triggerMethod("dom:refresh")}e.on({show:t,render:n})},function(e){function t(t,n,r,s){var o=s.split(/\s+/);i.each(o,function(i){var s=t[i];if(!s)throw new e.Error('Method "'+i+'" was configured as an event handler, but does not exist.');t.listenTo(n,r,s)})}function n(e,t,i,n){e.listenTo(t,i,n)}function r(e,t,n,r){var s=r.split(/\s+/);i.each(s,function(i){var r=e[i];e.stopListening(t,n,r)})}function s(e,t,i,n){e.stopListening(t,i,n)}function o(t,n,r,s,o){if(n&&r){if(!i.isObject(r))throw new e.Error({message:"Bindings must be an object or function.",url:"marionette.functions.html#marionettebindentityevents"});r=e._getValue(r,t),i.each(r,function(e,r){i.isFunction(e)?s(t,n,r,e):o(t,n,r,e)})}}e.bindEntityEvents=function(e,i,r){o(e,i,r,n,t)},e.unbindEntityEvents=function(e,t,i){o(e,t,i,s,r)},e.proxyBindEntityEvents=function(t,i){return e.bindEntityEvents(this,t,i)},e.proxyUnbindEntityEvents=function(t,i){return e.unbindEntityEvents(this,t,i)}}(r);var o=["description","fileName","lineNumber","name","message","number"];return r.Error=r.extend.call(Error,{urlRoot:"http://marionettejs.com/docs/v"+r.VERSION+"/",constructor:function(e,t){i.isObject(e)?(t=e,e=t.message):t||(t={});var n=Error.call(this,e);i.extend(this,i.pick(n,o),i.pick(t,o)),this.captureStackTrace(),t.url&&(this.url=this.urlRoot+t.url)},captureStackTrace:function(){Error.captureStackTrace&&Error.captureStackTrace(this,r.Error)},toString:function(){return this.name+": "+this.message+(this.url?" See: "+this.url:"")}}),r.Error.extend=r.extend,r.Callbacks=function(){this._deferred=r.Deferred(),this._callbacks=[]},i.extend(r.Callbacks.prototype,{add:function(e,t){var n=i.result(this._deferred,"promise");this._callbacks.push({cb:e,ctx:t}),n.then(function(i){t&&(i.context=t),e.call(i.context,i.options)})},run:function(e,t){this._deferred.resolve({options:e,context:t})},reset:function(){var e=this._callbacks;this._deferred=r.Deferred(),this._callbacks=[],i.each(e,function(e){this.add(e.cb,e.ctx)},this)}}),r.Controller=function(e){this.options=e||{},i.isFunction(this.initialize)&&this.initialize(this.options)},r.Controller.extend=r.extend,i.extend(r.Controller.prototype,t.Events,{destroy:function(){return r._triggerMethod(this,"before:destroy",arguments),r._triggerMethod(this,"destroy",arguments),this.stopListening(),this.off(),this},triggerMethod:r.triggerMethod,getOption:r.proxyGetOption}),r.Object=function(e){this.options=i.extend({},i.result(this,"options"),e),this.initialize.apply(this,arguments)},r.Object.extend=r.extend,i.extend(r.Object.prototype,t.Events,{initialize:function(){},destroy:function(){this.triggerMethod("before:destroy"),this.triggerMethod("destroy"),this.stopListening()},triggerMethod:r.triggerMethod,getOption:r.proxyGetOption,bindEntityEvents:r.proxyBindEntityEvents,unbindEntityEvents:r.proxyUnbindEntityEvents}),r.Region=r.Object.extend({constructor:function(e){if(this.options=e||{},this.el=this.getOption("el"),this.el=this.el instanceof t.$?this.el[0]:this.el,!this.el)throw new r.Error({name:"NoElError",message:'An "el" must be specified for a region.'});this.$el=this.getEl(this.el),r.Object.call(this,e)},show:function(e,t){if(this._ensureElement()){this._ensureViewIsIntact(e);var i=t||{},n=e!==this.currentView,s=!!i.preventDestroy,o=!!i.forceShow,h=!!this.currentView,a=n&&!s,l=n||o;if(h&&this.triggerMethod("before:swapOut",this.currentView,this,t),this.currentView&&delete this.currentView._parent,a?this.empty():h&&l&&this.currentView.off("destroy",this.empty,this),l){e.once("destroy",this.empty,this),e.render(),e._parent=this,h&&this.triggerMethod("before:swap",e,this,t),this.triggerMethod("before:show",e,this,t),r.triggerMethodOn(e,"before:show",e,this,t),h&&this.triggerMethod("swapOut",this.currentView,this,t);var u=r.isNodeAttached(this.el),d=[],c=i.triggerBeforeAttach||this.triggerBeforeAttach,g=i.triggerAttach||this.triggerAttach;return u&&c&&(d=this._displayedViews(e),this._triggerAttach(d,"before:")),this.attachHtml(e),this.currentView=e,u&&g&&(d=this._displayedViews(e),this._triggerAttach(d)),h&&this.triggerMethod("swap",e,this,t),this.triggerMethod("show",e,this,t),r.triggerMethodOn(e,"show",e,this,t),this}return this}},triggerBeforeAttach:!0,triggerAttach:!0,_triggerAttach:function(e,t){var n=(t||"")+"attach";i.each(e,function(e){r.triggerMethodOn(e,n,e,this)},this)},_displayedViews:function(e){return i.union([e],i.result(e,"_getNestedViews")||[])},_ensureElement:function(){if(i.isObject(this.el)||(this.$el=this.getEl(this.el),this.el=this.$el[0]),!this.$el||0===this.$el.length){if(this.getOption("allowMissingEl"))return!1;throw new r.Error('An "el" '+this.$el.selector+" must exist in DOM")}return!0},_ensureViewIsIntact:function(e){if(!e)throw new r.Error({name:"ViewNotValid",message:"The view passed is undefined and therefore invalid. You must pass a view instance to show."});if(e.isDestroyed)throw new r.Error({name:"ViewDestroyedError",message:'View (cid: "'+e.cid+'") has already been destroyed and cannot be used.'})},getEl:function(e){return t.$(e,r._getValue(this.options.parentEl,this))},attachHtml:function(e){this.$el.contents().detach(),this.el.appendChild(e.el)},empty:function(){var e=this.currentView;if(e)return e.off("destroy",this.empty,this),this.triggerMethod("before:empty",e),this._destroyView(),this.triggerMethod("empty",e),delete this.currentView,this},_destroyView:function(){var e=this.currentView;e.destroy&&!e.isDestroyed?e.destroy():e.remove&&(e.remove(),e.isDestroyed=!0)},attachView:function(e){return this.currentView=e,this},hasView:function(){return!!this.currentView},reset:function(){return this.empty(),this.$el&&(this.el=this.$el.selector),delete this.$el,this}},{buildRegion:function(e,t){if(i.isString(e))return this._buildRegionFromSelector(e,t);if(e.selector||e.el||e.regionClass)return this._buildRegionFromObject(e,t);if(i.isFunction(e))return this._buildRegionFromRegionClass(e);throw new r.Error({message:"Improper region configuration type.",url:"marionette.region.html#region-configuration-types"})},_buildRegionFromSelector:function(e,t){return new t({el:e})},_buildRegionFromObject:function(e,t){var n=e.regionClass||t,r=i.omit(e,"selector","regionClass");return e.selector&&!r.el&&(r.el=e.selector),new n(r)},_buildRegionFromRegionClass:function(e){return new e}}),r.RegionManager=r.Controller.extend({constructor:function(e){this._regions={},r.Controller.call(this,e),this.addRegions(this.getOption("regions"))},addRegions:function(e,t){return e=r._getValue(e,this,arguments),i.reduce(e,function(e,n,r){return i.isString(n)&&(n={selector:n}),n.selector&&(n=i.defaults({},n,t)),e[r]=this.addRegion(r,n),e},{},this)},addRegion:function(e,t){var i;return i=t instanceof r.Region?t:r.Region.buildRegion(t,r.Region),this.triggerMethod("before:add:region",e,i),i._parent=this,this._store(e,i),this.triggerMethod("add:region",e,i),i},get:function(e){return this._regions[e]},getRegions:function(){return i.clone(this._regions)},removeRegion:function(e){var t=this._regions[e];return this._remove(e,t),t},removeRegions:function(){var e=this.getRegions();return i.each(this._regions,function(e,t){this._remove(t,e)},this),e},emptyRegions:function(){var e=this.getRegions();return i.invoke(e,"empty"),e},destroy:function(){return this.removeRegions(),r.Controller.prototype.destroy.apply(this,arguments)},_store:function(e,t){this._regions[e]=t,this._setLength()},_remove:function(e,t){this.triggerMethod("before:remove:region",e,t),t.empty(),t.stopListening(),delete t._parent,delete this._regions[e],this._setLength(),this.triggerMethod("remove:region",e,t)},_setLength:function(){this.length=i.size(this._regions)}}),r.actAsCollection(r.RegionManager.prototype,"_regions"),r.TemplateCache=function(e){this.templateId=e},i.extend(r.TemplateCache,{templateCaches:{},get:function(e){var t=this.templateCaches[e];return t||(t=new r.TemplateCache(e),this.templateCaches[e]=t),t.load()},clear:function(){var e,t=i.toArray(arguments),n=t.length;if(n>0)for(e=0;n>e;e++)delete this.templateCaches[t[e]];else this.templateCaches={}}}),i.extend(r.TemplateCache.prototype,{load:function(){if(this.compiledTemplate)return this.compiledTemplate;var e=this.loadTemplate(this.templateId);return this.compiledTemplate=this.compileTemplate(e),this.compiledTemplate},loadTemplate:function(e){var i=t.$(e).html();if(!i||0===i.length)throw new r.Error({name:"NoTemplateError",message:'Could not find template: "'+e+'"'});return i},compileTemplate:function(e){return i.template(e)}}),r.Renderer={render:function(e,t){if(!e)throw new r.Error({name:"TemplateNotFoundError",message:"Cannot render the template since its false, null or undefined."});var n=i.isFunction(e)?e:r.TemplateCache.get(e);return n(t)}},r.View=t.View.extend({isDestroyed:!1,constructor:function(e){i.bindAll(this,"render"),e=r._getValue(e,this),this.options=i.extend({},i.result(this,"options"),e),this._behaviors=r.Behaviors(this),t.View.apply(this,arguments),r.MonitorDOMRefresh(this),this.on("show",this.onShowCalled)},getTemplate:function(){return this.getOption("template")},serializeModel:function(e){return e.toJSON.apply(e,i.rest(arguments))},mixinTemplateHelpers:function(e){e=e||{};var t=this.getOption("templateHelpers");return t=r._getValue(t,this),i.extend(e,t)},normalizeUIKeys:function(e){var t=i.result(this,"_uiBindings");return r.normalizeUIKeys(e,t||i.result(this,"ui"))},normalizeUIValues:function(e){var t=i.result(this,"ui"),n=i.result(this,"_uiBindings");return r.normalizeUIValues(e,n||t)},configureTriggers:function(){if(this.triggers){var e=this.normalizeUIKeys(i.result(this,"triggers"));return i.reduce(e,function(e,t,i){return e[i]=this._buildViewTrigger(t),e},{},this)}},delegateEvents:function(e){return this._delegateDOMEvents(e),this.bindEntityEvents(this.model,this.getOption("modelEvents")),this.bindEntityEvents(this.collection,this.getOption("collectionEvents")),i.each(this._behaviors,function(e){e.bindEntityEvents(this.model,e.getOption("modelEvents")),e.bindEntityEvents(this.collection,e.getOption("collectionEvents"))},this),this},_delegateDOMEvents:function(e){var n=r._getValue(e||this.events,this);n=this.normalizeUIKeys(n),i.isUndefined(e)&&(this.events=n);var s={},o=i.result(this,"behaviorEvents")||{},h=this.configureTriggers(),a=i.result(this,"behaviorTriggers")||{};i.extend(s,o,n,h,a),t.View.prototype.delegateEvents.call(this,s)},undelegateEvents:function(){return t.View.prototype.undelegateEvents.apply(this,arguments),this.unbindEntityEvents(this.model,this.getOption("modelEvents")),this.unbindEntityEvents(this.collection,this.getOption("collectionEvents")),i.each(this._behaviors,function(e){e.unbindEntityEvents(this.model,e.getOption("modelEvents")),e.unbindEntityEvents(this.collection,e.getOption("collectionEvents"))},this),this},onShowCalled:function(){},_ensureViewIsIntact:function(){if(this.isDestroyed)throw new r.Error({name:"ViewDestroyedError",message:'View (cid: "'+this.cid+'") has already been destroyed and cannot be used.'})},destroy:function(){if(!this.isDestroyed){var e=i.toArray(arguments);return this.triggerMethod.apply(this,["before:destroy"].concat(e)),this.isDestroyed=!0,this.triggerMethod.apply(this,["destroy"].concat(e)),this.unbindUIElements(),this.remove(),i.invoke(this._behaviors,"destroy",e),this}},bindUIElements:function(){this._bindUIElements(),i.invoke(this._behaviors,this._bindUIElements)},_bindUIElements:function(){if(this.ui){this._uiBindings||(this._uiBindings=this.ui);var e=i.result(this,"_uiBindings");this.ui={},i.each(e,function(e,t){this.ui[t]=this.$(e)},this)}},unbindUIElements:function(){this._unbindUIElements(),i.invoke(this._behaviors,this._unbindUIElements)},_unbindUIElements:function(){this.ui&&this._uiBindings&&(i.each(this.ui,function(e,t){delete this.ui[t]},this),this.ui=this._uiBindings,delete this._uiBindings)},_buildViewTrigger:function(e){var t=i.isObject(e),n=i.defaults({},t?e:{},{preventDefault:!0,stopPropagation:!0}),r=t?n.event:e;return function(e){e&&(e.preventDefault&&n.preventDefault&&e.preventDefault(),e.stopPropagation&&n.stopPropagation&&e.stopPropagation());var t={view:this,model:this.model,collection:this.collection};this.triggerMethod(r,t)}},setElement:function(){var e=t.View.prototype.setElement.apply(this,arguments);return i.invoke(this._behaviors,"proxyViewProperties",this),e},triggerMethod:function(){for(var e=r._triggerMethod,t=e(this,arguments),i=this._behaviors,n=0,s=i&&i.length;s>n;n++)e(i[n],arguments);return t},_getImmediateChildren:function(){return[]},_getNestedViews:function(){var e=this._getImmediateChildren();return e.length?i.reduce(e,function(e,t){return t._getNestedViews?e.concat(t._getNestedViews()):e},e):e},normalizeMethods:r.normalizeMethods,getOption:r.proxyGetOption,bindEntityEvents:r.proxyBindEntityEvents,unbindEntityEvents:r.proxyUnbindEntityEvents}),r.ItemView=r.View.extend({constructor:function(){r.View.apply(this,arguments)},serializeData:function(){if(!this.model&&!this.collection)return{};var e=[this.model||this.collection];return arguments.length&&e.push.apply(e,arguments),this.model?this.serializeModel.apply(this,e):{items:this.serializeCollection.apply(this,e)}},serializeCollection:function(e){return e.toJSON.apply(e,i.rest(arguments))},render:function(){return this._ensureViewIsIntact(),this.triggerMethod("before:render",this),this._renderTemplate(),this.bindUIElements(),this.triggerMethod("render",this),this},_renderTemplate:function(){var e=this.getTemplate();if(e!==!1){if(!e)throw new r.Error({name:"UndefinedTemplateError",message:"Cannot render the template since it is null or undefined."});var t=this.serializeData();t=this.mixinTemplateHelpers(t);var i=r.Renderer.render(e,t,this);return this.attachElContent(i),this}},attachElContent:function(e){return this.$el.html(e),this}}),r.CollectionView=r.View.extend({childViewEventPrefix:"childview",constructor:function(e){var t=e||{};i.isUndefined(this.sort)&&(this.sort=i.isUndefined(t.sort)?!0:t.sort),this.once("render",this._initialEvents),this._initChildViewStorage(),r.View.apply(this,arguments),this.initRenderBuffer()},initRenderBuffer:function(){this.elBuffer=document.createDocumentFragment(),this._bufferedChildren=[]},startBuffering:function(){this.initRenderBuffer(),this.isBuffering=!0},endBuffering:function(){this.isBuffering=!1,this._triggerBeforeShowBufferedChildren(),this.attachBuffer(this,this.elBuffer),this._triggerShowBufferedChildren(),this.initRenderBuffer()},_triggerBeforeShowBufferedChildren:function(){this._isShown&&i.each(this._bufferedChildren,i.partial(this._triggerMethodOnChild,"before:show"))},_triggerShowBufferedChildren:function(){this._isShown&&(i.each(this._bufferedChildren,i.partial(this._triggerMethodOnChild,"show")),this._bufferedChildren=[])},_triggerMethodOnChild:function(e,t){r.triggerMethodOn(t,e)},_initialEvents:function(){this.collection&&(this.listenTo(this.collection,"add",this._onCollectionAdd),this.listenTo(this.collection,"remove",this._onCollectionRemove),this.listenTo(this.collection,"reset",this.render),this.sort&&this.listenTo(this.collection,"sort",this._sortViews))},_onCollectionAdd:function(e){this.destroyEmptyView();var t=this.getChildView(e),i=this.collection.indexOf(e);this.addChild(e,t,i)},_onCollectionRemove:function(e){var t=this.children.findByModel(e);this.removeChildView(t),this.checkEmpty()},onShowCalled:function(){this.children.each(i.partial(this._triggerMethodOnChild,"show"))},render:function(){return this._ensureViewIsIntact(),this.triggerMethod("before:render",this),this._renderChildren(),this.triggerMethod("render",this),this},resortView:function(){this.render()},_sortViews:function(){var e=this.collection.find(function(e,t){var i=this.children.findByModel(e);return!i||i._index!==t},this);e&&this.resortView()},_emptyViewIndex:-1,_renderChildren:function(){this.destroyEmptyView(),this.destroyChildren(),this.isEmpty(this.collection)?this.showEmptyView():(this.triggerMethod("before:render:collection",this),this.startBuffering(),this.showCollection(),this.endBuffering(),this.triggerMethod("render:collection",this))},showCollection:function(){var e;this.collection.each(function(t,i){e=this.getChildView(t),this.addChild(t,e,i)},this)},showEmptyView:function(){var e=this.getEmptyView();if(e&&!this._showingEmptyView){this.triggerMethod("before:render:empty"),this._showingEmptyView=!0;var i=new t.Model;this.addEmptyView(i,e),this.triggerMethod("render:empty")}},destroyEmptyView:function(){this._showingEmptyView&&(this.triggerMethod("before:remove:empty"),this.destroyChildren(),delete this._showingEmptyView,this.triggerMethod("remove:empty"))},getEmptyView:function(){return this.getOption("emptyView")},addEmptyView:function(e,t){var n=this.getOption("emptyViewOptions")||this.getOption("childViewOptions");i.isFunction(n)&&(n=n.call(this,e,this._emptyViewIndex));var s=this.buildChildView(e,t,n);s._parent=this,this.proxyChildEvents(s),this._isShown&&r.triggerMethodOn(s,"before:show"),this.children.add(s),this.renderChildView(s,this._emptyViewIndex),this._isShown&&r.triggerMethodOn(s,"show")},getChildView:function(){var e=this.getOption("childView");if(!e)throw new r.Error({name:"NoChildViewError",message:'A "childView" must be specified'});return e},addChild:function(e,t,i){var n=this.getOption("childViewOptions");n=r._getValue(n,this,[e,i]);var s=this.buildChildView(e,t,n);return this._updateIndices(s,!0,i),this._addChildView(s,i),s._parent=this,s},_updateIndices:function(e,t,i){this.sort&&(t&&(e._index=i),this.children.each(function(i){i._index>=e._index&&(i._index+=t?1:-1)}))},_addChildView:function(e,t){this.proxyChildEvents(e),this.triggerMethod("before:add:child",e),this.children.add(e),this.renderChildView(e,t),this._isShown&&!this.isBuffering&&r.triggerMethodOn(e,"show"),this.triggerMethod("add:child",e)},renderChildView:function(e,t){return e.render(),this.attachHtml(this,e,t),e},buildChildView:function(e,t,n){var r=i.extend({model:e},n);return new t(r)},removeChildView:function(e){return e&&(this.triggerMethod("before:remove:child",e),e.destroy?e.destroy():e.remove&&e.remove(),delete e._parent,this.stopListening(e),this.children.remove(e),this.triggerMethod("remove:child",e),this._updateIndices(e,!1)),e},isEmpty:function(){return!this.collection||0===this.collection.length},checkEmpty:function(){this.isEmpty(this.collection)&&this.showEmptyView()},attachBuffer:function(e,t){e.$el.append(t)},attachHtml:function(e,t,i){e.isBuffering?(e.elBuffer.appendChild(t.el),e._bufferedChildren.push(t)):e._insertBefore(t,i)||e._insertAfter(t)},_insertBefore:function(e,t){var i,n=this.sort&&this.children.length-1>t;return n&&(i=this.children.find(function(e){return e._index===t+1})),i?(i.$el.before(e.el),!0):!1},_insertAfter:function(e){this.$el.append(e.el)},_initChildViewStorage:function(){this.children=new t.ChildViewContainer},destroy:function(){return this.isDestroyed?void 0:(this.triggerMethod("before:destroy:collection"),this.destroyChildren(),this.triggerMethod("destroy:collection"),r.View.prototype.destroy.apply(this,arguments))},destroyChildren:function(){var e=this.children.map(i.identity);return this.children.each(this.removeChildView,this),this.checkEmpty(),e},proxyChildEvents:function(e){var t=this.getOption("childViewEventPrefix");this.listenTo(e,"all",function(){var n=i.toArray(arguments),r=n[0],s=this.normalizeMethods(i.result(this,"childEvents"));n[0]=t+":"+r,n.splice(1,0,e),s!==void 0&&i.isFunction(s[r])&&s[r].apply(this,n.slice(1)),this.triggerMethod.apply(this,n)},this)},_getImmediateChildren:function(){return i.values(this.children._views)}}),r.CompositeView=r.CollectionView.extend({constructor:function(){r.CollectionView.apply(this,arguments)},_initialEvents:function(){this.collection&&(this.listenTo(this.collection,"add",this._onCollectionAdd),this.listenTo(this.collection,"remove",this._onCollectionRemove),this.listenTo(this.collection,"reset",this._renderChildren),this.sort&&this.listenTo(this.collection,"sort",this._sortViews))},getChildView:function(){var e=this.getOption("childView")||this.constructor;return e},serializeData:function(){var e={};return this.model&&(e=i.partial(this.serializeModel,this.model).apply(this,arguments)),e},render:function(){return this._ensureViewIsIntact(),this.isRendered=!0,this.resetChildViewContainer(),this.triggerMethod("before:render",this),this._renderTemplate(),this._renderChildren(),this.triggerMethod("render",this),this},_renderChildren:function(){this.isRendered&&r.CollectionView.prototype._renderChildren.call(this)},_renderTemplate:function(){var e={};e=this.serializeData(),e=this.mixinTemplateHelpers(e),this.triggerMethod("before:render:template");var t=this.getTemplate(),i=r.Renderer.render(t,e,this);this.attachElContent(i),this.bindUIElements(),this.triggerMethod("render:template")},attachElContent:function(e){return this.$el.html(e),this},attachBuffer:function(e,t){var i=this.getChildViewContainer(e);i.append(t)},_insertAfter:function(e){var t=this.getChildViewContainer(this,e);t.append(e.el)},getChildViewContainer:function(e){if("$childViewContainer"in e)return e.$childViewContainer;var t,i=r.getOption(e,"childViewContainer");if(i){var n=r._getValue(i,e);if(t="@"===n.charAt(0)&&e.ui?e.ui[n.substr(4)]:e.$(n),0>=t.length)throw new r.Error({name:"ChildViewContainerMissingError",message:'The specified "childViewContainer" was not found: '+e.childViewContainer})}else t=e.$el;return e.$childViewContainer=t,t},resetChildViewContainer:function(){this.$childViewContainer&&delete this.$childViewContainer}}),r.LayoutView=r.ItemView.extend({regionClass:r.Region,constructor:function(e){e=e||{},this._firstRender=!0,this._initializeRegions(e),r.ItemView.call(this,e)},render:function(){return this._ensureViewIsIntact(),this._firstRender?this._firstRender=!1:this._reInitializeRegions(),r.ItemView.prototype.render.apply(this,arguments)},destroy:function(){return this.isDestroyed?this:(this.regionManager.destroy(),r.ItemView.prototype.destroy.apply(this,arguments))},addRegion:function(e,t){var i={};return i[e]=t,this._buildRegions(i)[e]},addRegions:function(e){return this.regions=i.extend({},this.regions,e),this._buildRegions(e)},removeRegion:function(e){return delete this.regions[e],this.regionManager.removeRegion(e)},getRegion:function(e){return this.regionManager.get(e)},getRegions:function(){return this.regionManager.getRegions()},_buildRegions:function(e){var t={regionClass:this.getOption("regionClass"),parentEl:i.partial(i.result,this,"el")};return this.regionManager.addRegions(e,t)},_initializeRegions:function(e){var t;this._initRegionManager(),t=r._getValue(this.regions,this,[e])||{};var n=this.getOption.call(e,"regions");n=r._getValue(n,this,[e]),i.extend(t,n),t=this.normalizeUIValues(t),this.addRegions(t)},_reInitializeRegions:function(){this.regionManager.invoke("reset")},getRegionManager:function(){return new r.RegionManager},_initRegionManager:function(){this.regionManager=this.getRegionManager(),this.regionManager._parent=this,this.listenTo(this.regionManager,"before:add:region",function(e){this.triggerMethod("before:add:region",e)}),this.listenTo(this.regionManager,"add:region",function(e,t){this[e]=t,this.triggerMethod("add:region",e,t)}),this.listenTo(this.regionManager,"before:remove:region",function(e){this.triggerMethod("before:remove:region",e)}),this.listenTo(this.regionManager,"remove:region",function(e,t){delete this[e],this.triggerMethod("remove:region",e,t)})},_getImmediateChildren:function(){return i.chain(this.regionManager.getRegions()).pluck("currentView").compact().value()}}),r.Behavior=r.Object.extend({constructor:function(e,t){this.view=t,this.defaults=i.result(this,"defaults")||{},this.options=i.extend({},this.defaults,e),r.Object.apply(this,arguments)
},$:function(){return this.view.$.apply(this.view,arguments)},destroy:function(){this.stopListening()},proxyViewProperties:function(e){this.$el=e.$el,this.el=e.el}}),r.Behaviors=function(e,t){function i(e,n){return t.isObject(e.behaviors)?(n=i.parseBehaviors(e,n||t.result(e,"behaviors")),i.wrap(e,n,t.keys(s)),n):{}}function n(e,i){this._view=e,this._viewUI=t.result(e,"ui"),this._behaviors=i,this._triggers={}}var r=/^(\S+)\s*(.*)$/,s={behaviorTriggers:function(e,t){var i=new n(this,t);return i.buildBehaviorTriggers()},behaviorEvents:function(i,n){var s={},o=this._uiBindings||t.result(this,"ui");return t.each(n,function(i,n){var h={},a=t.clone(t.result(i,"events"))||{},l=i._uiBindings||t.result(i,"ui"),u=t.extend({},o,l);a=e.normalizeUIKeys(a,u);var d=0;t.each(a,function(e,s){var o=s.match(r),a=o[1]+"."+[this.cid,n,d++," "].join(""),l=o[2],u=a+l,c=t.isFunction(e)?e:i[e];h[u]=t.bind(c,i)},this),s=t.extend(s,h)},this),s}};return t.extend(i,{behaviorsLookup:function(){throw new e.Error({message:"You must define where your behaviors are stored.",url:"marionette.behaviors.html#behaviorslookup"})},getBehaviorClass:function(t,n){return t.behaviorClass?t.behaviorClass:e._getValue(i.behaviorsLookup,this,[t,n])[n]},parseBehaviors:function(e,n){return t.chain(n).map(function(n,r){var s=i.getBehaviorClass(n,r),o=new s(n,e),h=i.parseBehaviors(e,t.result(o,"behaviors"));return[o].concat(h)}).flatten().value()},wrap:function(e,i,n){t.each(n,function(n){e[n]=t.partial(s[n],e[n],i)})}}),t.extend(n.prototype,{buildBehaviorTriggers:function(){return t.each(this._behaviors,this._buildTriggerHandlersForBehavior,this),this._triggers},_buildTriggerHandlersForBehavior:function(i,n){var r=t.extend({},this._viewUI,t.result(i,"ui")),s=t.clone(t.result(i,"triggers"))||{};s=e.normalizeUIKeys(s,r),t.each(s,t.bind(this._setHandlerForBehavior,this,i,n))},_setHandlerForBehavior:function(e,t,i,n){var r=n.replace(/^\S+/,function(e){return e+"."+"behaviortriggers"+t});this._triggers[r]=this._view._buildViewTrigger(i)}}),i}(r,i),r.AppRouter=t.Router.extend({constructor:function(e){this.options=e||{},t.Router.apply(this,arguments);var i=this.getOption("appRoutes"),n=this._getController();this.processAppRoutes(n,i),this.on("route",this._processOnRoute,this)},appRoute:function(e,t){var i=this._getController();this._addAppRoute(i,e,t)},_processOnRoute:function(e,t){if(i.isFunction(this.onRoute)){var n=i.invert(this.getOption("appRoutes"))[e];this.onRoute(e,n,t)}},processAppRoutes:function(e,t){if(t){var n=i.keys(t).reverse();i.each(n,function(i){this._addAppRoute(e,i,t[i])},this)}},_getController:function(){return this.getOption("controller")},_addAppRoute:function(e,t,n){var s=e[n];if(!s)throw new r.Error('Method "'+n+'" was not found on the controller');this.route(t,n,i.bind(s,e))},getOption:r.proxyGetOption,triggerMethod:r.triggerMethod,bindEntityEvents:r.proxyBindEntityEvents,unbindEntityEvents:r.proxyUnbindEntityEvents}),r.Application=r.Object.extend({constructor:function(e){this._initializeRegions(e),this._initCallbacks=new r.Callbacks,this.submodules={},i.extend(this,e),this._initChannel(),r.Object.call(this,e)},execute:function(){this.commands.execute.apply(this.commands,arguments)},request:function(){return this.reqres.request.apply(this.reqres,arguments)},addInitializer:function(e){this._initCallbacks.add(e)},start:function(e){this.triggerMethod("before:start",e),this._initCallbacks.run(e,this),this.triggerMethod("start",e)},addRegions:function(e){return this._regionManager.addRegions(e)},emptyRegions:function(){return this._regionManager.emptyRegions()},removeRegion:function(e){return this._regionManager.removeRegion(e)},getRegion:function(e){return this._regionManager.get(e)},getRegions:function(){return this._regionManager.getRegions()},module:function(e,t){var n=r.Module.getClass(t),s=i.toArray(arguments);return s.unshift(this),n.create.apply(n,s)},getRegionManager:function(){return new r.RegionManager},_initializeRegions:function(e){var t=i.isFunction(this.regions)?this.regions(e):this.regions||{};this._initRegionManager();var n=r.getOption(e,"regions");return i.isFunction(n)&&(n=n.call(this,e)),i.extend(t,n),this.addRegions(t),this},_initRegionManager:function(){this._regionManager=this.getRegionManager(),this._regionManager._parent=this,this.listenTo(this._regionManager,"before:add:region",function(){r._triggerMethod(this,"before:add:region",arguments)}),this.listenTo(this._regionManager,"add:region",function(e,t){this[e]=t,r._triggerMethod(this,"add:region",arguments)}),this.listenTo(this._regionManager,"before:remove:region",function(){r._triggerMethod(this,"before:remove:region",arguments)}),this.listenTo(this._regionManager,"remove:region",function(e){delete this[e],r._triggerMethod(this,"remove:region",arguments)})},_initChannel:function(){this.channelName=i.result(this,"channelName")||"global",this.channel=i.result(this,"channel")||t.Wreqr.radio.channel(this.channelName),this.vent=i.result(this,"vent")||this.channel.vent,this.commands=i.result(this,"commands")||this.channel.commands,this.reqres=i.result(this,"reqres")||this.channel.reqres}}),r.Module=function(e,t,n){this.moduleName=e,this.options=i.extend({},this.options,n),this.initialize=n.initialize||this.initialize,this.submodules={},this._setupInitializersAndFinalizers(),this.app=t,i.isFunction(this.initialize)&&this.initialize(e,t,this.options)},r.Module.extend=r.extend,i.extend(r.Module.prototype,t.Events,{startWithParent:!0,initialize:function(){},addInitializer:function(e){this._initializerCallbacks.add(e)},addFinalizer:function(e){this._finalizerCallbacks.add(e)},start:function(e){this._isInitialized||(i.each(this.submodules,function(t){t.startWithParent&&t.start(e)}),this.triggerMethod("before:start",e),this._initializerCallbacks.run(e,this),this._isInitialized=!0,this.triggerMethod("start",e))},stop:function(){this._isInitialized&&(this._isInitialized=!1,this.triggerMethod("before:stop"),i.invoke(this.submodules,"stop"),this._finalizerCallbacks.run(void 0,this),this._initializerCallbacks.reset(),this._finalizerCallbacks.reset(),this.triggerMethod("stop"))},addDefinition:function(e,t){this._runModuleDefinition(e,t)},_runModuleDefinition:function(e,n){if(e){var s=i.flatten([this,this.app,t,r,t.$,i,n]);e.apply(this,s)}},_setupInitializersAndFinalizers:function(){this._initializerCallbacks=new r.Callbacks,this._finalizerCallbacks=new r.Callbacks},triggerMethod:r.triggerMethod}),i.extend(r.Module,{create:function(e,t,n){var r=e,s=i.rest(arguments,3);t=t.split(".");var o=t.length,h=[];return h[o-1]=n,i.each(t,function(t,i){var o=r;r=this._getModule(o,t,e,n),this._addModuleDefinition(o,r,h[i],s)},this),r},_getModule:function(e,t,n,r){var s=i.extend({},r),o=this.getClass(r),h=e[t];return h||(h=new o(t,n,s),e[t]=h,e.submodules[t]=h),h},getClass:function(e){var t=r.Module;return e?e.prototype instanceof t?e:e.moduleClass||t:t},_addModuleDefinition:function(e,t,i,n){var r=this._getDefine(i),s=this._getStartWithParent(i,t);r&&t.addDefinition(r,n),this._addStartWithParent(e,t,s)},_getStartWithParent:function(e,t){var n;return i.isFunction(e)&&e.prototype instanceof r.Module?(n=t.constructor.prototype.startWithParent,i.isUndefined(n)?!0:n):i.isObject(e)?(n=e.startWithParent,i.isUndefined(n)?!0:n):!0},_getDefine:function(e){return!i.isFunction(e)||e.prototype instanceof r.Module?i.isObject(e)?e.define:null:e},_addStartWithParent:function(e,t,i){t.startWithParent=t.startWithParent&&i,t.startWithParent&&!t.startWithParentIsConfigured&&(t.startWithParentIsConfigured=!0,e.addInitializer(function(e){t.startWithParent&&t.start(e)}))}}),r});
/*
//@ sourceMappingURL=backbone.marionette.map
*/