"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection.key-relative-chord-seq",
            inherit: "view._default",

            options: {
                canHaveBase: true,
            },

            defaultConfigParameterValues: {
                sequenceCount:              100,
                sequenceRepresentation:     "parallel-coordinates",
                chordGrouppingIsByType:     "",
                guidesAreVisible:           "1",
                recordingsInMajorModeAreIncluded: "1",
                recordingsInMinorModeAreIncluded: "1",

                chordTypesArePopularOnly:   "",
                chordSequencesWithCyclesAreIncluded: "1",
                nIsIncluded:                "",
                sequenceStepCount:          2,
                minSupport:                 50
            },


            // =================================================================
            // config grid header

            _generateHeaderLabelSuffix: function(headerView) {
                var sequenceCount  =   this.getConfigParameterValueOrDefaultValue(headerView.options.config, "sequenceCount", true);
                return _.str.sprintf(" (%s most frequent)", sequenceCount);
                //return _.str.sprintf(" (up to %s)", this.getConfigParameterValueOrDefaultValue(headerView.options.config, "limit"));
            },


            // =================================================================
            // vis instance rendering

            calculateVisInstanceContentHeight: function(viewConfig, entityWidth) {
                var representation = this.getConfigParameterValueOrDefaultValue(viewConfig, "representaton", true);
                return entityWidth;
            },


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                var result = {
                        "spm_maxseqs":    this.getConfigParameterValueOrDefaultValue(viewConfig, "sequenceCount", true),
                        "spm_minlen":     this.getConfigParameterValueOrDefaultValue(viewConfig, "sequenceStepCount", true),
                        "spm_ignore_n":   this.getConfigParameterValueOrDefaultValue(viewConfig, "nIsIncluded", true) == "1" ? "0" : "1",
                        "spm_minsupport": this.getConfigParameterValueOrDefaultValue(viewConfig, "minSupport", true),
                    };
                return result;
            },


            _doRenderVisInstanceViewBaseWithKnownComparisonMode: function(visInstanceView, comparisonMode) {
                var viewConfig = visInstanceView.options.viewConfig;

                var options = {};
                options.comparisonMode = comparisonMode;

                options.chordGrouppingIsByType           = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "chordGrouppingIsByType", true);
                options.guidesAreVisible                 = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "guidesAreVisible", true);
                options.recordingsInMajorModeAreIncluded = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "recordingsInMajorModeAreIncluded", true);
                options.recordingsInMinorModeAreIncluded = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "recordingsInMinorModeAreIncluded", true);
                options.nIsIncluded                      = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "nIsIncluded", true);
                options.stepCount                        =   this.getConfigParameterValueOrDefaultValue(viewConfig, "sequenceStepCount", true);
                options.chordSequencesWithCyclesAreIncluded = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "chordSequencesWithCyclesAreIncluded", true);
                options.sequenceOfUsedChordTypes = [0, 1, 2, 3, 4, 6];
                if (!!this.getConfigParameterValueOrDefaultValue(viewConfig, "chordTypesArePopularOnly", true)) {
                    //options.sequenceOfUsedChordTypes = [0, 3];
                }

                options.primaryColor = "#3182bd";
                options.secondaryColor = "#31a354";

                var representation = this.getConfigParameterValueOrDefaultValue(viewConfig, "sequenceRepresentation", true);
                App.GraphicsRenderingModule.render("chord-seq." + representation, visInstanceView.$content, this._groupDataForGraphicsRendering(visInstanceView, "base"), options);
            },

        });
    });
}, Logger);
