"use strict";

App.module("GraphicsRenderingModule", function(GraphicsRenderingModule, App, Backbone, Marionette, $, _, Logger) {

    GraphicsRenderingModule.addInitializer(function(options){

        GraphicsRenderingModule.registerRenderer({
            id: "similarity-matrix",
            inherit: "_",

            defaultVegaConfig: {
                comparisonMode: null,

                colorForData: "#3182bd",

                padding: {"top": 5, "left": 0, "bottom": 0, "right": 0},
            },


            _formVC: function(vc, data) {
                vc.enoughSpaceForAxisLabels = vc.totalWidth > 200;
                vc.width  = vc.totalWidth  - vc.padding.left - vc.padding.right;
                vc.height = vc.totalHeight - vc.padding.top  - vc.padding.bottom;

                var stats = {
                        list: [],
                        distance: []
                }
                if (data.self.stats) {
                    data.self.stats = stats
                }
                var recordingCount = stats.list.length;


                // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                // Data
                var distance = stats.distance;
                var list = stats.list;

                // .............................................................
                // Data - cells
                var cellsInVegaData = [];
                var maxDistance = 0;
                for (var column = 0; column < recordingCount; ++column) {
                    for (var row = 0; row < recordingCount; ++row) {
                        var currentDistance = distance[row][column];
                        if (currentDistance < 1E-5) {
                            currentDistance = 0;
                        }
                        var cellInVegaData = {
                                column:     column,
                                row:        row,
                                nextColumn: column + 1,
                                nextRow:    row + 1,
                                distance:   currentDistance
                            };
                        if (column != row) {
                            cellInVegaData.tooltip =  "↔ " + list[row].label
                                + "<br/>↕   " + list[column].label
                                + "<br/>" + GraphicsRenderingModule._formatNumberForTooltip(cellInVegaData.distance);
                        } else {
                            cellInVegaData.tooltip =  list[row].label;
                        }

                        cellsInVegaData.push(cellInVegaData);
                        if (cellInVegaData.distance > maxDistance) {
                            maxDistance = cellInVegaData.distance;
                        }
                    }
                }

                vc.data.push({
                    "name": "cells",
                    "values": cellsInVegaData
                });


                // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                // Scales

                // .............................................................
                // Scale - columns
                vc.scales.push({
                    //"type": "ordinal",
                    "name": "column",
                    "domainMin": 0,
                    "domainMax": recordingCount,
                    "point": true,
                    "round": true,
                    "range": [0, vc.width]
                });

                // .............................................................
                // Scale - rows
                vc.scales.push({
                    //"type": "ordinal",
                    "name": "row",
                    "domainMin": 0,
                    "domainMax": recordingCount,
                    "point": true,
                    "round": true,
                    "range": [0, vc.height]
                });

                // .............................................................
                // Scale - fill opacity
                vc.scales.push({
                    "name": "fillOpacity",
                    "type": "linear",
                    "domain": [0, maxDistance],
                    "point": true,
                    "range": [0, 1]
                });


                // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                // Marks

                // .............................................................
                // Mark - background (to catch mouse events and remove tooltips)
                vc.marks.push({
                   "type": "rect",
                   "properties": {
                       "enter": {
                           "x": {"value": -vc.padding.left},
                           "y": {"value": -vc.padding.top},
                           "fill": {"value": "#fff"},
                           "y2": {"field": {"group": "height"}, "offset": vc.padding.left + vc.padding.right},
                           "x2": {"field": {"group": "width"}, "offset": vc.padding.top + vc.padding.bottom},
                       }
                   }
                });


                // .............................................................
                // Mark - cells

                vc.marks.push({
                    "type": "rect",
                    "from": {"data": "cells"},
                    "properties": {
                        "enter": {
                            "x":  {"field": "column", "scale": "column"},
                            "x2": {"field": "nextColumn", "scale": "column", "offset": -1},
                            "y":  {"field": "row", "scale": "row"},
                            "y2": {"field": "nextRow", "scale": "row", "offset": -1},
                            "fill": {"value": vc.colorForData},
                            "fillOpacity": {"field": "distance", "scale": "fillOpacity"},
                        }
                    }
                });

            },
        });
    });
}, Logger);
