/**
 * Changes the default functionality of _.uniqueId()
 *
 * Adds a new function _.markUniqueIdAsAlreadyUsed
 *
 * Quicker alternative to
 *  _.isObject(serializedAttributes) && !_.isArray(serializedAttributes)  && !_.isFunction(serializedAttributes)
 *
 * @memberOf _
 */
var toString = Object.prototype.toString;
if (_) {
    _.mixin({
        isEventAnAttemptToOpenANewTab: function(event) {
            return event.ctrlKey || event.shiftKey || event.metaKey || event.which == 2;
        }
    });
} else {
    console.error("Can't register _.isClickAnAttemptToOpenANewTab without underscore.js (global variable '_')");
}
