// By default TemplateCache fails to load templates that have zero length
// 
Backbone.Marionette.TemplateCache.prototype.loadTemplate = function(templateId) {
    var $template = Backbone.$(templateId);
    if (!$template.length) {
        throw new Marionette.Error({
            name : 'NoTemplateError',
            message : 'Could not find template: "' + templateId + '"'
        });
    }
    return $template.html();
};