"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.recording._histogram",
            inherit: "view._histogram",

            options: {
            },


            // =================================================================
            // dynamic derived vis instance data


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                return {};
            },


            // =================================================================
            // vis instance rendering

            _generateHistogramOptions: function(pid) {

                var options = {};
                options.colorForBars = "#31a354";
                options.layer = "base";

                options.dataDefinition = {};
                options.dataDefinition.forXs = null;
                options.dataDefinition.forBars = null;
                options.dataDefinition.forFlats = null;

                switch (pid) {
                case "tempo-nonuniform":
                    options.dataDefinition.forceXsAreEdges = true;
                case "tempo-normalised":
                    options.dataDefinition.forXs = "times";
                    options.dataDefinition.forBars = "values";
                    break;
                case "midi-pitch-histogram":
                    options.dataDefinition.forXs = "values";
                    options.dataDefinition.forBars = "counts";
                    break;
                case "pitch-histogram":
                case "tempo-histogram":
                    options.dataDefinition.forXs = "edges";
                    options.dataDefinition.forBars = "counts";
                    break;
                }

                return options;
            }
        });
    });
}, Logger);
