"use strict";

App.module("GraphicsRenderingModule", function(GraphicsRenderingModule, App, Backbone, Marionette, $, _, Logger) {

    GraphicsRenderingModule.addInitializer(function(options){

        GraphicsRenderingModule.registerRenderer({
            id: "similarity-plane",
            inherit: "_",

            defaultVegaConfig: {
                comparisonMode: null,

                symbolSize: 20,
                internalSpaceOffset: 6,
                colorForData: "#3182bd",

                padding: {"top": 10, "left": 10, "bottom": 10, "right": 10},
            },


            _formVC: function(vc, data) {
                vc.enoughSpaceForAxisLabels = vc.totalWidth > 200;
                vc.width  = vc.totalWidth  - vc.padding.left - vc.padding.right;
                vc.height = vc.totalHeight - vc.padding.top  - vc.padding.bottom;

                var stats = {
                        mds: [],
                        list: []
                }
                if (data.self.stats) {
                    data.self.stats = stats
                }
                var recordingCount = stats.list.length;

                // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                // Data
                var mds = stats.mds;
                var list = stats.list;

                // .............................................................
                // Data - points
                var pointsInVegaData = [];
                for (var i = 0; i < recordingCount; ++i) {
                    var pointInVegaData = {
                            x:     mds[i][0],
                            y:     mds[i][1]
                        };
                    pointInVegaData.tooltip = list[i].label;
//                                            + "<br/>x: " + GraphicsRenderingModule._formatNumberForTooltip(pointInVegaData.x)
//                                            + "<br/>y: " + GraphicsRenderingModule._formatNumberForTooltip(pointInVegaData.y)

                    pointsInVegaData.push(pointInVegaData);
                }

                vc.data.push({
                    "name": "points",
                    "values": pointsInVegaData
                });


                // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                // Scales

                // .............................................................
                // Scale - x
                vc.scales.push({
                    "name": "x",
                    "domain": {"data": "points", "field": "x"},
                    "point": true,
                    "round": true,
                    "zero":  true,
                    "range": [vc.internalSpaceOffset, vc.width - vc.internalSpaceOffset]
                });

                // .............................................................
                // Scale - y
                vc.scales.push({
                    "name": "y",
                    "domain": {"data": "points", "field": "y"},
                    "point": true,
                    "round": true,
                    "zero":  true,
                    "inverse": true,
                    "range": [vc.internalSpaceOffset, vc.height - vc.internalSpaceOffset]
                });


                // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                // Marks

                // .............................................................
                // Mark - background (to catch mouse events and remove tooltips)
                vc.marks.push({
                   "type": "rect",
                   "properties": {
                       "enter": {
                           "x": {"value": -vc.padding.left},
                           "y": {"value": -vc.padding.top},
                           "fill": {"value": "#fff"},
                           "y2": {"field": {"group": "height"}, "offset": vc.padding.left + vc.padding.right},
                           "x2": {"field": {"group": "width"}, "offset": vc.padding.top + vc.padding.bottom},
                       }
                   }
                });


                // .............................................................
                // Mark - frame
                vc.marks.push({
                    "type": "rect",
                    "properties": {
                        "enter": {
                            "y": {"value": 0, "offset": .5},
                            "y2": {"field": {"group": "height"}, "offset": -.5},
                            "x": {"value": 0, "offset": .5},
                            "x2": {"field": {"group": "width"}, "offset": -.5},
                            "stroke": {"value": vc.colorForAxes},
                            "strokeWidth": {"value": 1},
//                            "x":  {"value": 0, "scale": "x" "offset": -1},
//                            "width": {"value": 1},
                        }
                    }
                 });

                // .............................................................
                // Mark - x axis
//                vc.marks.push({
//                   "type": "rect",
//                   "properties": {
//                       "enter": {
//                           "x": {"value": 0},
//                           "x2": {"field": {"group": "width"}},
//                           "fill": {"value": vc.colorForAxes},
//                           "y":  {"value": 0, "scale": "y"},
//                           "height": {"value": 1},
//                       }
//                   }
//                });


                // .............................................................
//                // Mark - y axis
//                vc.marks.push({
//                   "type": "rect",
//                   "properties": {
//                       "enter": {
//                           "y": {"value": 0},
//                           "y2": {"field": {"group": "height"}},
//                           "fill": {"value": vc.colorForAxes},
//                           "x":  {"value": 0, "scale": "x", "offset": -1},
//                           "width": {"value": 1},
//                       }
//                   }
//                });

                // .............................................................
                // Mark - cells
                vc.marks.push({
                    "type": "symbol",
                    "from": {"data": "points"},
                    "properties": {
                        "enter": {
                            "x":  {"field": "x", "scale": "x"},
                            "y":  {"field": "y", "scale": "y"},
                            "size": {"value": vc.symbolSize},
                            "fill": {"value": vc.colorForData}
                        }
                    }
                });


            },
        });
    });
}, Logger);
