"use strict";

App.module("MainRegionModule", function (MainRegionModule, App, Backbone, Marionette, $, _, Logger) {

    MainRegionModule.MainRegionView = Backbone.View.extend({

        initialize: function(options) {
            var _this = this;
            _this.options = _.defaults(options || {}, this.options);

            var $collectionsGridEl = _this.$(".config-grid");
            var $recordingsGridEl = $collectionsGridEl.clone();
            $recordingsGridEl.appendTo(_this.el);

            // Render when the state changes
            _this.options.state.on("change", function() {
                _this.render();
            });

            // Init sub-views
            _this._musicCollectionConfigGridView = new MainRegionModule.ConfigGridView({
                    el: $collectionsGridEl,
                    state: _this.options.state,
                    configGrid: _this.options.state.get("musicCollectionGrid"),
                    parentState: _this.options.state,
                    parentContainerElement: _this.el
                });

            _this._musicRecordingConfigGridView  = new MainRegionModule.ConfigGridView({
                    el: $recordingsGridEl,
                    state: _this.options.state,
                    configGrid: _this.options.state.get("musicRecordingGrid"),
                    parentState: _this.options.state,
                    parentContainerElement: _this.el
                });

            _this._$flipper = $.bem.generateElement("main-region", "flipper");

            _this._$flipper.append(
                    _this._musicRecordingConfigGridView.$ghost,
                    _this._musicCollectionConfigGridView.$ghost
            );
            _this._$flipperContainer = $.bem.generateElement("main-region", "flipper-container");
            _this._$flipperContainer.append(_this._$flipper);

            _this._$flipper.on(
                    "transitionend MSTransitionEnd webkitTransitionEnd oTransitionEnd",
                    function() {
                        _this._stopFlipping();
                    }
                );

            _this.render(true, true);
        },

        render: function(deep, instant) {
            var _this = this;

            var musicRecordingsGridNeedsToBeShown = !! _this.options.state.get("musicRecordingsGridIsShown");
            var gridViewToShow =  musicRecordingsGridNeedsToBeShown ? _this._musicRecordingConfigGridView : _this._musicCollectionConfigGridView;
            var gridViewToHide = !musicRecordingsGridNeedsToBeShown ? _this._musicRecordingConfigGridView : _this._musicCollectionConfigGridView;

            // need to swap grids
            if (!gridViewToShow.el.getAttribute("data-active")) {

                // launch the flipper
                if (!instant) {
                    if (!_this.isSwitchingBetweenGrids()) {
                        _this._$flipper.removeClass("main-region__flipper_animating");
                        _this._$flipper.setMod("main-region", "flipper", "to", !musicRecordingsGridNeedsToBeShown ? "recording" : "collection");
                        _this._$flipper.addClass("main-region__flipper_animating");
                        _this._$flipperContainer.appendTo(_this.el);
                    }
                    setTimeout(function() {
                        _this._$flipper.setMod("main-region", "flipper", "to", musicRecordingsGridNeedsToBeShown ? "recording" : "collection");
                    }, 10);
                }

                // swap the grids and render a new current one
                gridViewToHide.$el.attr("data-active", null).detach();
                gridViewToShow.$el.attr("data-active", "1") .appendTo(_this.$el);
//                gridViewToHide.$el.attr("data-active", null).hide();
//                gridViewToShow.$el.attr("data-active", "1") .show();
                gridViewToShow.render(true, true);

            // no need to swap grids - render only if it's a deep render
            } else if (deep) {
                gridViewToShow.render(deep, instant);
            }
        },

        isSwitchingBetweenGrids: function() {
            var _this = this;
            return _this._$flipperContainer.parent().length;
        },

        _stopFlipping: function() {
            var _this = this;
            _this._$flipperContainer.detach();
        },
    });
}, Logger);