"use strict";

App.module("ContextModule", function(ContextModule, App, Backbone, Marionette, $, _, Logger) {

    // Prevent auto start
    ContextModule.startWithParent = false;
    
    // Define options
    var defaultModuleOptions = {
            stateHistoryMaxLength: 20
    };

    // Define private variables
    var logger = null;

    // Initialization checker
    var assertModuleIsInitialized = function() {
        if (!logger) {
            throw "ContextModule has not been initialized";
        }
    };
    
    /**
     * Module initializer
     * 
     */
    ContextModule.addInitializer(function(options){
        
        ContextModule.moduleOptions = _.extend(defaultModuleOptions, options);
        
        logger = Logger.get("ContextModule");
        //logger.setLevel(Logger.DEBUG);
    });
}, Logger);
