/* global ChordVis */
'use strict';

App.module('TooltipModule', function (TooltipModule, App, Backbone, Marionette, $, _) {
    var renderFunctions = {};

    var OBJECT_TYPE_CHORD_SEQUENCE = 1;

    TooltipModule.addInitializer(function() {


        TooltipModule.TooltipView = Backbone.View.extend({

            initialize: function(options) {
                var _this = this;

                _this.$tooltip = $("<div/>").addClass("tooltip").appendTo("body");
            },

            update: function(mouseEvent, title, target) {
                var _this = this;
                // removing the tooltip
                if (!mouseEvent || mouseEvent.type == "mouseout" || mouseEvent.type == "mouseup" || !title) {
                     _this.previousTarget = null;
                     _this.$tooltip.addClass("tooltip_animation_slow-opacity");
                     _this.$tooltip.removeClass("tooltip_state_visible");
                 } else {
                     if (target != _this.previousTarget) {
                         _this.$tooltip.removeClass("tooltip_animation_slow-opacity");
                         _this.$tooltip.addClass("tooltip_state_visible");

                         _this.$tooltip.html(title);
                     }

                     _this.$tooltip.position({
                         of: mouseEvent,
                         my: "left+20 topt+20",
                         collision: "flip flip"
                     });
                 };
             }
//            update: function(mouseEvent, object) {
//                var _this = this;
//                var objectType = null;
//                if (object && object.sequenceAsObject && object.sequenceAsObject && object.sequenceAsObject.frequency && object.sequenceAsObject.chordsInOrder) {
//                    objectType = OBJECT_TYPE_CHORD_SEQUENCE;
//                }
//                if (!mouseEvent || mouseEvent.type == "mouseout" || !objectType) {
//                     _this.previousObject = null;
//                     _this.$tooltip.addClass("tooltip_animation_slow-opacity");
//                     _this.$tooltip.removeClass("tooltip_state_visible");
//                 } else {
//                     if (object != _this.previousObject) {
//                         _this.$tooltip.removeClass("tooltip_animation_slow-opacity");
//                         _this.$tooltip.addClass("tooltip_state_visible");
//                         // Chord sequence
//                         if (objectType == OBJECT_TYPE_CHORD_SEQUENCE) {
//                             _this.previousObject = object;
//
//                             var chordIds = _.pluck(object.sequenceAsObject.chordsInOrder, "id");
//                             var chordTitles = [];
//                             for (var i = 0; i < chordIds.length; i++) {
//                                 chordTitles.push(_this.bankOfChords.get(chordIds[i]).getNormalisedId());
//                            }
//                             var frequency = object.sequenceAsObject.frequency;
//                             _this.$tooltip.html(_.str.sprintf("%s<br/>in %s%% of recordings", chordTitles.join(" → "), _.str.numberFormat(frequency, 2)));
//                         }
//                     }
//
//                     _this.$tooltip.position({
//                         of: mouseEvent,
//                         my: "left+20 topt+20",
//                         collision: "flip flip"
//                     });
//                 };
//             }
        });

        TooltipModule.tooltipView = new TooltipModule.TooltipView();

        TooltipModule._updateTooltipForDOMNodeWithExTitle = function(mouseEvent) {
            TooltipModule.tooltipView.update(mouseEvent, $(this).attr("tooltip-title"), this);
        };


        TooltipModule.update = function(mouseEvent, title, target) {
            TooltipModule.tooltipView.update(mouseEvent, title, target);
        };

        TooltipModule.convertTitlesToTooltips = function($container) {
            $container.find("[title]").each(function(){
                var $this = $(this);
                $this
                    .attr("tooltip-title", $this.attr("title"))
                    .removeAttr("title");
                if (App.options.enableTooltipsForControlsWithTitles) {
                    $this
                        .on('mouseover', TooltipModule._updateTooltipForDOMNodeWithExTitle)
                        .on('mouseout', TooltipModule._updateTooltipForDOMNodeWithExTitle)
                        .on('mousemove', TooltipModule._updateTooltipForDOMNodeWithExTitle)
                        .on('mouseup', TooltipModule._updateTooltipForDOMNodeWithExTitle);
                }

            });
        };
    });
});