"use strict";

App.module("DataModule", function(DataModule, App, Backbone, Marionette, $, _, Logger) {
    // Prevent auto start
    //CollectionDefinitionProvider.startWithParent = false;

    // Define private variables
    var logger = null;

    /**
     * Module initializer
     *
     */
    DataModule.addInitializer(function(){

        logger = Logger.get("App.DataModule");

        DataModule.DynamicDefinitionForCollection = DataModule.DynamicDefinition.extend({});
        DataModule.DynamicDefinitionProviderForCollections = DataModule.DynamicDefinitionProvider.extend({

            options: {
                DynamicDefinition:                 DataModule.DynamicDefinitionForCollection,
                apiMethod:                         "getCollectionId",
                customAttributesWhenNotApplicable: {id: undefined},
                customAttributesWhileBeingUpdated: {id: null, sampleSize: null, fullSize: null},
                customAttributesWhenFaulty:        {id: false, sampleSize: false, fullSize: false},

                customAttributesWhenEmpty:         {id: "", sampleSize: 0, fullSize: 0}
            },

            definitionIsFaulty: function(definition) {
                return definition.id === false;
            },

            definitionIsBeingUpdated: function(definition) {
                return definition.id === null;
            },

            configParametersToRequestParameters: function(config) {
                var rawConfigParameters = config.attributes.parameters.attributes;
                var requestParameters = {};
                var library = _.str.trim(rawConfigParameters.library).replace(/ /g, "").replace(/,/g, ";");
                if (library) {
                    requestParameters.library = library;
                } else {
                    return null;
                }
                requestParameters.sv = 0;
                var year = _.str.trim(rawConfigParameters.year).replace(/ /g, "");
                if (year) {
                    requestParameters.year = year;
                }

                //FIXME (hard-coded sample size)
                requestParameters.sample = 1000;

                _.each(["genre", "composer", "performer", "title", "place", "collection"], function(field) {
                    var f = _.str.trim(rawConfigParameters[field]);
                    if (f) {
                        requestParameters[field] = f;
                    };
                });

                return requestParameters;
            },

            apiResponseToAttributes: function(data, query) {
                var attributes = {};

                if (data && data.cid) {
                    attributes.id = data.cid;
                    attributes.sampleSize = data.size;
                    attributes.fullSize = data.full_size;
                } else if  (data.errors && data.errors[0] && _.isString(data.errors[0].desc) && data.errors[0].desc.indexOf("empty_dataset") > 0) {
                    attributes = _.clone(this.options.customAttributesWhenEmpty);
                } else {
                    attributes = _.clone(this.options.customAttributesWhenFaulty);
                    attributes.errors = data.errors;
                    logger.warn("An error occured when attempting to obtain collection definition. Query / response:", query, data);
                };
                attributes.query = query;
                return attributes;
            }
        });
    });
}, Logger);
