"use strict";

App.addInitializer(function(options){
    var _this = this;

    /* =========================================================================
     * Global key shortcuts
     */
    var $document = $(document);

    var aPopupIsOpen = function() {
        return App.helpIsShowing();
    };
    var askToClosePopups = function() {
    };

    $document.bind("keydown", "esc", function(event) {
        if (App.helpIsShowing()) {
            App.hideHelp();
        }
    });
    $document.bind("keydown", "h", function(event) {
        if (App.helpIsShowing()) {
            App.hideHelp();
        } else {
            App.showHelp();
        }
    });
    $document.bind("keydown", "f", function(event) {
        if (aPopupIsOpen()) {
            return false;
        }
        var state = App.context.get("state");
        state.set("musicRecordingsGridIsShown", !state.get("musicRecordingsGridIsShown"));
    });

    $document.bind("keydown", App.keyboardMappings.ctrl + "+z", function(event) {
        if (aPopupIsOpen()) {
            askToClosePopups();
            return false;
        }
        App.undo();
    });

    $document.bind("keydown", App.keyboardMappings.ctrlShift + "+z", function(event) {
        if (aPopupIsOpen()) {
            askToClosePopups();
            return false;
        }
        App.redo();
    });

    var moveConfig = function(dimension, offset) {
        var state = App.context.get("state");
        var configGrid = state.get(state.get("musicRecordingsGridIsShown") ? "musicRecordingGrid" : "musicCollectionGrid");
        var configs = null;
        if (dimension == "entity") {
            configs = configGrid.get("entityConfigs");
            var selectedConfig = configGrid.getSelectedEntityConfig();
            if (selectedConfig) {
                var configToInsertBefore;
                if (offset == 1) {
                    configToInsertBefore = configGrid.getNextEntityNeighbour(selectedConfig);
                    if (configToInsertBefore) {
                        configToInsertBefore = configGrid.getNextEntityNeighbour(configToInsertBefore);
                    }
                } else {
                    configToInsertBefore = configGrid.getPrevEntityNeighbour(selectedConfig);
                    if (!configToInsertBefore) {
                        return;
                    }
                }
                configGrid.relocateEntityConfig(selectedConfig, configToInsertBefore ? configToInsertBefore : null);
            }
        } else {
            configs = configGrid.get("viewConfigs");
            var selectedConfig = configGrid.getSelectedViewConfig();
            if (selectedConfig) {
                var configToInsertBefore;
                if (offset == 1) {
                    configToInsertBefore = configGrid.getNextViewNeighbour(selectedConfig);
                    if (configToInsertBefore) {
                        configToInsertBefore = configGrid.getNextViewNeighbour(configToInsertBefore);
                    }
                } else {
                    configToInsertBefore = configGrid.getPrevViewNeighbour(selectedConfig);
                    if (!configToInsertBefore) {
                        return;
                    }
                }
                configGrid.relocateViewConfig(selectedConfig, configToInsertBefore ? configToInsertBefore : null);
            }
        }
    };

    $document.bind("keydown", "alt+left", function(event) {
        if (aPopupIsOpen()) {
            askToClosePopups();
            return false;
        }
        moveConfig("entity", -1);
        event.preventDefault();
        return false;
    });

    $document.bind("keydown", "alt+right", function(event) {
        if (aPopupIsOpen()) {
            askToClosePopups();
            return false;
        }
        moveConfig("entity", 1);
        event.preventDefault();
        return false;
    });

    $document.bind("keydown", "alt+up", function(event) {
        if (aPopupIsOpen()) {
            askToClosePopups();
            return false;
        }
        moveConfig("view", -1);
        event.preventDefault();
        return false;
    });
    $document.bind("keydown", "alt+down", function(event) {
        if (aPopupIsOpen()) {
            askToClosePopups();
            return false;
        }
        moveConfig("view", 1);
        event.preventDefault();
        return false;
    });

});
