/**
 * Returns true if an argument is an object, but is not an array or a function
 * 
 * Quicker alternative to
 *  _.isObject(serializedAttributes) && !_.isArray(serializedAttributes)  && !_.isFunction(serializedAttributes)
 *  
 * @memberOf _
 */
var toString = Object.prototype.toString;
if (_) {
    _.mixin({
        isSimpleObject: function(obj) {
            return toString.call(obj) === "[object Object]" && obj.constructor === Object;
        }
    });
} else {
    console.error("Can't register _.isSimpleObject without underscore.js (global variable '_')");
}
