describe("_.isSimpleObject()", function() {
    it("returns true for simple objects", function() {
        expect(_.isSimpleObject({}))
            .toBe(true);
        expect(_.isSimpleObject({"x": "y"}))
            .toBe(true);
    });
    
    it("returns false for not simple objects (not objects + arrays, functions, etc.)", function() {
        expect(_.isSimpleObject(undefined))
            .toBe(false);
        expect(_.isSimpleObject(null))
            .toBe(false);
        expect(_.isSimpleObject(1))
            .toBe(false);
        expect(_.isSimpleObject("test"))
            .toBe(false);
        expect(_.isSimpleObject([]))
            .toBe(false);
        expect(_.isSimpleObject([1, 2, 3]))
            .toBe(false);
        expect(_.isSimpleObject(["foo", "bar"]))
            .toBe(false);
        expect(_.isSimpleObject(function(){"test";}))
            .toBe(false);
        expect(_.isSimpleObject(App))
            .toBe(false);
        expect(_.isSimpleObject(new App.ContextModule.Config()))
            .toBe(false);
    });
});
