"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "entity._",
            inherit: "_",


            // =================================================================
            // config grid header

            _generateCollectionConfigTitle: function(config) {
                var rawConfigParameters = config.attributes.parameters.attributes;
                var labelParts = [];
                if (rawConfigParameters.library) {
                    if (rawConfigParameters.genre) {
                        labelParts.push(rawConfigParameters.genre);
                    }
                    if (rawConfigParameters.collection) {
                        if (!rawConfigParameters.place) {
                            labelParts.push("recordings");
                        }
                        labelParts.push(" in ‘", rawConfigParameters.collection, "’ collection");
                    }
                    if (rawConfigParameters.genre && (rawConfigParameters.title || rawConfigParameters.composer)) {
                        labelParts.push(" / ");
                    }
                    if (rawConfigParameters.composer) {
                        labelParts.push(rawConfigParameters.composer);
                    }
                    if (rawConfigParameters.title && rawConfigParameters.composer) {
                        labelParts.push(" – ");
                    }
                    if (rawConfigParameters.title) {
                        labelParts.push(rawConfigParameters.title);
                    }
                    if (rawConfigParameters.year) {
                        labelParts.push(" (", rawConfigParameters.year, ")");
                    }
                    if (rawConfigParameters.place) {
                        labelParts.push(" from ", rawConfigParameters.place);
                    }

                    if (labelParts.length) {
                        labelParts.unshift(": ");
                    }
                    if (!RepresentationModule.getMasterById("entity._")._cachedLibraryLabelsByLibraryId) {
                        var cachedLibraryLabelsByLibraryId = {};
                        var $panelContents = $(Marionette.TemplateCache.get("#cgpma_collection_entity_default")());
                        var $tickboxes = $panelContents.find(".cgpma__tickbox");
                        $tickboxes.each(function() {
                            var $tickbox = $(this);
                            var id = $tickbox.getMod("cgpma_", "id");
                            cachedLibraryLabelsByLibraryId[id] = $tickbox.text();
                        });
                        RepresentationModule.getMasterById("entity._")._cachedLibraryLabelsByLibraryId = cachedLibraryLabelsByLibraryId;
                    }
                    var libraries = rawConfigParameters.library.toLowerCase().split(";");
                    var libraryLabels = [];
                    for (var i = 0; i < libraries.length; i++) {
                        libraryLabels.push(RepresentationModule.getMasterById("entity._")._cachedLibraryLabelsByLibraryId[_.str.trim(libraries[i])]);
                    }
                    labelParts.unshift(libraryLabels.join(", "));

                } else {
                    labelParts.push("an empty collection");
                }
                return labelParts.join("");
            },


            _doRenderHeaderContentRelatedToOwnData: function(entityHeaderView, instant) {
                if (!entityHeaderView._$label1) {
                    entityHeaderView._$label1     = $.bem.generateElement("config-grid-cells", "entity-header-label").appendTo(entityHeaderView.$el);
                    entityHeaderView._$label2     = $.bem.generateElement("config-grid-cells", "entity-header-label", ["row2"]).appendTo(entityHeaderView.$el);
                    entityHeaderView._$labelFader = $.bem.generateElement("config-grid-cells", "entity-header-label-fader").appendTo(entityHeaderView.$el);
                }
                if (entityHeaderView.options.config.hasPlannedParameterUpdates()) {
                    entityHeaderView._$label1.html("<span class=\"config-grid-cells__view-header-label-part_modified\">" + this._generateHeaderLabel1(entityHeaderView) + "</span>");
                    entityHeaderView._$label2.html("being modified");
                } else {
                    entityHeaderView._$label1.html(this._generateHeaderLabel1(entityHeaderView));
                    entityHeaderView._$label2.html(this._generateHeaderLabel2(entityHeaderView));
                }
            },

            _generateHeaderLabel1: function(entityHeaderView) {return "";},
            _generateHeaderLabel2: function(entityHeaderView) {return "";},


            // =================================================================
            // dynamic derived vis instance data

            __coverTapActionThatUpdatesDynamicDerivedData: function() {
                var $cover = $(this);
                var visInstanceView = $cover.data("visInstanceView");
                var derivedDataToUpdate = $cover.data("attachedError").options.derivedDataToUpdate;
                switch (derivedDataToUpdate) {
                case "entity":
                    visInstanceView.dynamicDerivedConfigDataForEntity.update();
                    break;
                case "view":
                    visInstanceView.dynamicDerivedConfigDataForView.update();
                    break;
                case "base":
                    visInstanceView.dynamicDerivedVisInstanceDataForBase.update();
                    break;
                case "overlay":
                    visInstanceView.dynamicDerivedVisInstanceDataForOverlay.update();
                    break;
                case "temp":
                    visInstanceView.dynamicDerivedVisInstanceDataForTemp.update();
                    break;
                default:
                    throw _.str.sprintf("__coverTapActionThatUpdatesDynamicDerivedData cannot be called for derivedDataToUpdate = %s", derivedDataToUpdate);
                }
            },


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - base

            _verifyThatViewIsNotEmptyOrUnknown: function(visInstanceView) {
                if (!visInstanceView._cachedViewMaster.options.canHaveBase) {
                    if (visInstanceView._cachedViewMaster.id == "view._unknown") {
                        throw new RepresentationModule.Error({type: "view_unknown"});
                    }
                    if (visInstanceView._cachedViewMaster.inherit == "view._default") {
                        throw new RepresentationModule.Error({type: "view_default"});
                    }
                    else throw "Unknown view master without base " + visInstanceView._cachedViewMaster.id ;
                }
            },


            verifyAllDataForVisInstanceBase:    function(visInstanceView) {},
            generateDynamicDerivedVisInstanceDataForBase: function(visInstanceView) {
                return new RepresentationModule.DynamicDerivedVisInstanceData();
            },


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - overlay

            verifyAllDataForVisInstanceOverlay: function(visInstanceView) {},
            generateDynamicDerivedVisInstanceDataForOverlay: function(visInstanceView) {
                if (visInstanceView._cachedViewMaster.generateDynamicDerivedVisInstanceDataForOverlay) {
                    return visInstanceView._cachedViewMaster.generateDynamicDerivedVisInstanceDataForOverlay(visInstanceView);
                } else {
                    return new RepresentationModule.DynamicDerivedVisInstanceData();
                }
            },


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - temp

            verifyAllDataForVisInstanceTemp:    function(visInstanceView) {},
            generateDynamicDerivedVisInstanceDataForTemp: function(visInstanceView) {
                return new RepresentationModule.DynamicDerivedVisInstanceData();
            },
        });
    });
}, Logger);
