"use strict";

/* =========================================================================
 * Methods that should be initialized after modules
 */
App.addInitializer(function(options){

    // help
    App.showHelp = function(options){
        App.HelpModule.show(options);
        App.MainMenuModule.flashItem("help");
    };
    App.hideHelp = function(options) {
        App.HelpModule.hide(options);
    };
    App.helpIsShowing = function() {
        return App.HelpModule.isShowing();
    };

    // notifications
    App.showNotification = function(options){
        App.NotificationsModule.show(options);
    };
    App.hideNotification = function(id){
        return App.NotificationsModule.hide(id);
    };

    // undo / redo
    var stateHistory = App.context.get("stateHistory");
    App.undo = function() {
        if (stateHistory.canUndo()) {
            stateHistory.undo();
            App.hideNotification("undo_redo");
        } else {
            App.showNotification({id: "undo_redo", content: Backbone.Marionette.TemplateCache.get("#notification-content_undo_na")});
        }
        App.MainMenuModule.flashItem("undo");
    };
    App.redo = function() {
        if (stateHistory.canRedo()) {
            stateHistory.redo();
            App.hideNotification("undo_redo");
        } else {
            App.showNotification({id: "undo_redo", content: Backbone.Marionette.TemplateCache.get("#notification-content_redo_na")});
        }
        App.MainMenuModule.flashItem("redo");
    };

    stateHistory.on("change", function() {
        App.hideNotification("undo_redo");
    });

    //
    App.showStateSharing = function() {
        App.showNotification({id: "states", modifiers: ["ttl_20"], content: Backbone.Marionette.TemplateCache.get("#notification-content_states_na")});
        App.MainMenuModule.flashItem("share");
    },

    App.showStateBookmarks = function() {
        App.showNotification({id: "states", modifiers: ["ttl_20"], content: Backbone.Marionette.TemplateCache.get("#notification-content_states_na")});
        App.MainMenuModule.flashItem("bookmarks");
    },

    // player
    App.play = function(recordingURI, time) {
        App.PlayerModule.play(recordingURI, time);
    };
});
