"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection.geography",
            inherit: "view._default",

            options: {
                canHaveBase: true,
                headerSuffixesForRegionValues: {
                    "planet": "whole planet",
                    "africa":  "Africa",
                    "europe":  "Europe",
                    "_unknown": "unknown region"
                },
                widthToHeightRatioByRegion: {
                    "planet": 0.5,
                    "africa":  1.1,
                    "europe":  0.8
                },
                widthToHeightRatio: 2,
                visInstanceContentHeightMin: 40,
                //visInstanceSupportedComparisonModes: ["superposition", "direct"],
                auxiliaryData: {
                    //"countries": "views/geography/countries.min.geojson"
                    "countryOutlines": "views/geography/world-110m.json",
                    "countries": "views/geography/countries.json",
                    "placeCountryNumericCodes": "views/geography/placeCountryNumericCodes.json" // run "app/console dml:views:geography:parse-places" and then "app/console dml:views:geography:extract-country-codes" to generate this file
                },
                auxiliaryAssets: [
                    //"views/geography/d3.geo.projection.min.js"
                ]
            },

            defaultConfigParameterValues: {
                displayRegion:         "planet",
                showCountriesAsCircles: ""
            },

            checkIfAuxiliaryAssetsAreReady: function() {
                return !!(d3 && d3.geo && _.isFunction(d3.geo.projection));
            },

            // =================================================================
            // config grid header

            _generateHeaderLabelSuffix: function(headerView) {
                var result = [];
                var region  =   this.getConfigParameterValueOrDefaultValue(headerView.options.config, "displayRegion", true);
                if (region != "planet") {
                    var regionLabel = this.options.headerSuffixesForRegionValues[region];
                    if (!regionLabel) {
                        regionLabel = this.options.headerSuffixesForRegionValues["_unknown"];
                    }
                    result.push(_.str.sprintf(" (%s)", regionLabel));
                }


                var showCountriesAsCircles  =   this.getConfigParameterValueOrDefaultValue(headerView.options.config, "showCountriesAsCircles", true);
                if (showCountriesAsCircles) {
                    result.push(", countries are shown as circles");
                }

                return result.join('');
            },


            // =================================================================
            // vis instance rendering

            calculateVisInstanceContentHeight: function(viewConfig, entityWidth) {
                var displayRegion = this.getConfigParameterValueOrDefaultValue(viewConfig, "displayRegion", true);
                var height = this.options.widthToHeightRatioByRegion[displayRegion] * entityWidth;
                if (!height) {
                    height = this.options.widthToHeightRatio;
                }
                if (height < this.options.visInstanceContentHeightMin) {
                    height = this.options.visInstanceContentHeightMin;
                }
                return height;
            },


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                var result = {
                        "pid": "places_hist"
                    };
                return result;
            },

            _doRenderVisInstanceViewBaseWithKnownComparisonMode: function(visInstanceView, comparisonMode) {
                var viewConfig = visInstanceView.options.viewConfig;

                // fixme precompute this somewhere else
                if (!visInstanceView._cachedViewMaster.auxiliaryData.countriesByCountryNumericCode) {
                    visInstanceView._cachedViewMaster.auxiliaryData.countriesByCountryNumericCode = {};
                    _.each(visInstanceView._cachedViewMaster.auxiliaryData.countries, function(country) {
                        visInstanceView._cachedViewMaster.auxiliaryData.countriesByCountryNumericCode[country[1]] = country;
                    });
                }

                var options = {};
                options.comparisonMode = comparisonMode;

                options.countryOutlines = visInstanceView._cachedViewMaster.auxiliaryData.countryOutlines;
                options.countries = visInstanceView._cachedViewMaster.auxiliaryData.countries;
                options.countriesByCountryNumericCode = visInstanceView._cachedViewMaster.auxiliaryData.countriesByCountryNumericCode;
                options.placeCountryNumericCodes = visInstanceView._cachedViewMaster.auxiliaryData.placeCountryNumericCodes;
                options.region = this.getConfigParameterValueOrDefaultValue(viewConfig, "displayRegion", true);
                options.showCountriesAsCircles = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "showCountriesAsCircles", true);

                App.GraphicsRenderingModule.render("geography", visInstanceView.$content, this._groupDataForGraphicsRendering(visInstanceView, "base"), options);
            },

        });
    });
}, Logger);
