"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "entity._pair",
            inherit: "entity._",

            defaultConfigParameterValues: {
                comparisonMode: "superposition"
            },


            // =================================================================
            // config grid panel


            // -----------------------------------------------------------------
            // config grid panel - prepare

            prepareConfigGridPanelMainArea: function(configGridPanelView) {
                // Comparison mode radio buttons (tick boxes)
                var $comparisonModeTickBoxes = configGridPanelView._$mainArea.find("[data-comparison-mode]");
                configGridPanelView._$mainArea.data("$tickboxes_comparisonMode", $comparisonModeTickBoxes);
                $comparisonModeTickBoxes.each(function() {
                    var $tickbox = $(this);
                    var comparisonMode = $tickbox.data("comparison-mode");
                    configGridPanelView._$mainArea.data("$tickbox_comparison-mode_" + comparisonMode, $tickbox);
                });

                // Parent master's behaviour
                RepresentationModule.getMasterById("entity._").prepareConfigGridPanelMainArea.apply(this, arguments);
            },


            __panelInputChangeValueHandler: function(event) {
                if (event.type == "tickboxchangevalue") {
                    var $thickbox = $(event.target);
                    var comparisonMode = $thickbox.data("comparisonMode");
                    if (comparisonMode) {
                        var configGridPanelView = $thickbox.data("configGridPanelView");
                        if (!configGridPanelView._$mainArea.data("ignoreChangesInComparisonModeTickboxes")) {
                            var master    = $thickbox.data("configGridPanelView")._masterBehindMainArea;
                            master.planConfigParameterUpdateWithRespectToValueAndDefaultValue(configGridPanelView._cachedConfig, "comparisonMode", comparisonMode);
                        }
                        return;
                    };
                }

                // Parent master's behaviour
                RepresentationModule.getMasterById("entity._").__panelInputChangeValueHandler.apply(this, arguments);
            },


            // -----------------------------------------------------------------
            // config grid panel - sync

            syncConfigGridPanelMainArea: function(configGridPanelView, instant) {

                // comparison mode tick boxes + field visibility
                var comparisonMode = this.getConfigParameterValueOrDefaultValue(configGridPanelView._cachedConfig, "comparisonMode").toLowerCase();
                var plannedComparisonMode = this.getConfigPlannedParameterValueOrDefaultValue(configGridPanelView._cachedConfig, "comparisonMode").toLowerCase();
                var comparisonModeHash = comparisonMode + plannedComparisonMode;
                if (configGridPanelView._$mainArea.data("comparisonModeHash") != comparisonModeHash) {
                    configGridPanelView._$mainArea.data("comparisonModeHash", comparisonModeHash);

                    // tick boxes
                    configGridPanelView._$mainArea.data("ignoreChangesInComparisonModeTickboxes", true);
                    configGridPanelView._$mainArea.data("$tickboxes_comparisonMode").each(function() {
                        var $tickbox = $(this);
                        var value = plannedComparisonMode == $tickbox.data("comparison-mode") ? "1" : "";
                        var baseValue = (comparisonMode !== plannedComparisonMode)
                                ? (value ? "" : "1")
                                : (value ? "1" : "");

                        $tickbox.tickbox("option", {
                            "value": value,
                            "baseValue": baseValue
                        });
                    });
                    configGridPanelView._$mainArea.removeData("ignoreChangesInComparisonModeTickboxes");

                    // show / hide input blocks
//                    var presentParameterNames = _.keys(this._getPresentParameterNamesForLibrary(plannedComparisonMode));
//                    var absentParameterNames = _.difference(_.keys(this.options.presenceOfParameters), presentParameterNames);
//
//                    for (var i = 0; i < presentParameterNames.length; i++) {
//                        configGridPanelView._$mainArea.data("$inputBlock_" + presentParameterNames[i]).show();
//                    }
//                    for (var i = 0; i < absentParameterNames.length; i++) {
//                        configGridPanelView._$mainArea.data("$inputBlock_" + absentParameterNames[i]).hide();
//                    }
                }

                // Parent master's behaviour
                RepresentationModule.getMasterById("entity._").syncConfigGridPanelMainArea.apply(this, arguments);
            },


            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // debug mode

            _mapDerivedVisInstanceDataAttributesToDebugAPIQueryBoxes: function (viewMaster) {
                if (viewMaster.options.visInstanceSupportedComparisonModes.length) {
                    return [["left",  "base", "apiRequestURIOnTheLeft",  "apiResponseOnTheLeft"],
                            ["right", "base", "apiRequestURIOnTheRight", "apiResponseOnTheRight"]];
                } else {
                    return [];
                }
            }
        });
    });
}, Logger);
