"use strict";

App.addInitializer(function(options){
    var _this = this;

    var popupsAreInstant = true;
    var appRouter = new (Backbone.Router.extend({
        routes: {
            "help": "navigateToHelp",
            "help/:id": "navigateToHelp",
            "": "navigateToDefault",
            "*notFound": "notFound",
        },

        navigateToHelp: function(id){
            //App.logger.log("Navigating to help with material id: ", id);
            App.HelpModule.show({materialId: id !== null ? id : "", instant: popupsAreInstant});
        },

        navigateToDefault: function(id){
            //App.logger.log("Navigating to default");
            App.HelpModule.hide();
        },

        notFound: function(context){
            App.logger.warn("Route not found", context);
        }
    }))();

    App.HelpModule.on("show", function(options) {
        var urlHash = "help";
        if (options.materialId) {
            urlHash += "/" + options.materialId;
        }
        var needToReplace = Backbone.history.fragment.slice(0, 4) == "help";
        appRouter.navigate(urlHash, {"replace": needToReplace});
    });

    App.HelpModule.on("hide", function(options) {
        appRouter.navigate("/");
    });

    Backbone.history.start({
    //      "pushState": true,
    //      "root": "/chords"
    });

    popupsAreInstant: false;
});
