"use strict";

App.module("ContextModule", function(ContextModule, App, Backbone, Marionette, $, _, Logger) {

    // Define private variables
    var logger = null;

    ContextModule.addInitializer(function(options){
        
        logger = Logger.get("ContextModule.StateBookmarkCollection");
        logger.setLevel(Logger.WARN);
        
        /**
         * StateBookmarkCollection is needed to store bookmarks for the states
         */
        ContextModule.StateBookmarkCollection = Backbone.Collection.extend({
            model: ContextModule.StateBookmark,
            
            serialize: function() {
                return this.map(function(model){ return model.serialize(); });
            },
            
            unserialize: function(serializedModels) {
                var fixedSerializedModels = serializedModels;
                if (!_.isArray(serializedModels)) {
                    logger.warn("StateBookmarkCollection::unserialize called for not an array: ", serializedModels);
                    fixedSerializedModels = [];
                }
                if (!_.isEqual(fixedSerializedModels, this.serialize())) {
                    var modelArray = [];
                    for (var i = 0; i < fixedSerializedModels.length; i++) {
                        var model = new this.model();
                        modelArray.push(model.unserialize(fixedSerializedModels[i]));
                    }
                    this.reset(modelArray);
                }
            }
        });
    });
}, Logger);
