"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "entity.collection.pair",
            inherit: "entity._pair",


            // =================================================================
            // config grid header

            _generateHeaderLabel1: function(entityHeaderView) {
                return _.str.sprintf("collection comparison (%s)", this.getConfigParameterValueOrDefaultValue(entityHeaderView.options.config, "comparisonMode"));
            },


            _generateHeaderLabel2: function(viewHeader) {
                var configOnTheLeft = viewHeader.dynamicDerivedConfigData.attributes.collectionConfigOnTheLeft;
                var configOnTheRight = viewHeader.dynamicDerivedConfigData.attributes.collectionConfigOnTheRight;

                var labelParts = [];

                if (configOnTheLeft) {
                    labelParts.push(this._generateCollectionConfigTitle(configOnTheLeft));
                } else {
                    labelParts.push("×");
                }

                labelParts.push("   ↔   ");

                if (configOnTheRight) {
                    labelParts.push(this._generateCollectionConfigTitle(configOnTheRight));
                } else {
                    labelParts.push("×");
                }

                return labelParts.join("");
            },


            // =================================================================
            // dynamic derived config data

            __optionsOfDynamicDerivedConfigData: {
                attributesToExcludeFromHash: ["collectionConfigOnTheLeft", "collectionConfigOnTheRight"],
                customHashSuffixGenerator: function (attributes) {
                    return (attributes.collectionConfigOnTheLeft  ? attributes.collectionConfigOnTheLeft. getClientId() : "x")
                         + (attributes.collectionConfigOnTheRight ? attributes.collectionConfigOnTheRight.getClientId() : "x");
//                    return (attributes.collectionConfigOnTheLeft  ? attributes.collectionConfigOnTheLeft. getHashForParameters() : "x")
//                         + (attributes.collectionConfigOnTheRight ? attributes.collectionConfigOnTheRight.getHashForParameters() : "x");
                }
            },


            __updateMethodOfDynamicDerivedConfigData: function (force) {
                this._doUpdate(force);
                if (this.attributes.collectionConfigOnTheLeft && this.attributes.dynamicDefinitionForCollectionOnTheLeft) {
                    return;
                }
                if (this.attributes.collectionConfigOnTheRight && this.attributes.dynamicDefinitionForCollectionOnTheRight) {
                    return;
                }
                var _this = this;
                var interval = setInterval(function() {
                    _this._doUpdate(force);
                    if (_this.attributes.collectionConfigOnTheLeft && !_this.attributes.dynamicDefinitionForCollectionOnTheLeft) {
                        return;
                    }
                    if (_this.attributes.collectionConfigOnTheRight && !_this.attributes.dynamicDefinitionForCollectionOnTheRight) {
                        return;
                    }
                    clearInterval(interval);
                }, 50);
            },

            __doUpdateMethodOfDynamicDerivedConfigData: function (force) {
                var entityConfig = this.options.entityConfig;
                var configGrid = this.options.configGrid;

                // do nothing with orphans (configs just before they are deleted)
                if (!entityConfig.getDimension()) {
                    return;
                }

                // find the nearest collections on the left and on the right
                var newCollectionConfigOnTheLeft = entityConfig;
                var newCollectionConfigOnTheRight = entityConfig;

                do {
                    newCollectionConfigOnTheLeft = configGrid.getPrevEntityNeighbour(newCollectionConfigOnTheLeft);
                } while (newCollectionConfigOnTheLeft && newCollectionConfigOnTheLeft.getParameterValue("kind") == "pair");

                do {
                    newCollectionConfigOnTheRight = configGrid.getNextEntityNeighbour(newCollectionConfigOnTheRight);
                } while (newCollectionConfigOnTheRight && newCollectionConfigOnTheRight.getParameterValue("kind") == "pair");

                var newDynamicDerivedConfigDataOnTheLeft  = App.dynamicDerivedConfigDataProvider.get(newCollectionConfigOnTheLeft);
                var newDynamicDerivedConfigDataOnTheRight = App.dynamicDerivedConfigDataProvider.get(newCollectionConfigOnTheRight);

                var newDynamicDefinitionForCollectionOnTheLeft  = newDynamicDerivedConfigDataOnTheLeft  ? newDynamicDerivedConfigDataOnTheLeft .attributes.dynamicDefinitionForCollection : null;
                var newDynamicDefinitionForCollectionOnTheRight = newDynamicDerivedConfigDataOnTheRight ? newDynamicDerivedConfigDataOnTheRight.attributes.dynamicDefinitionForCollection : null;

                var attributesToSet = {};

                var arrayOfShortcuts = [
                        [newCollectionConfigOnTheLeft,                "collectionConfigOnTheLeft",     "change:parameters", this.triggerChange],
                        [newCollectionConfigOnTheRight,               "collectionConfigOnTheRight",    "change:parameters", this.triggerChange],
                        [newDynamicDefinitionForCollectionOnTheLeft,  "dynamicDefinitionForCollectionOnTheLeft",  "change", this.triggerChange],
                        [newDynamicDefinitionForCollectionOnTheRight, "dynamicDefinitionForCollectionOnTheRight", "change", this.triggerChange],
                    ];

                for (var i = arrayOfShortcuts.length - 1; i >= 0; --i) {
                    var shortcuts = arrayOfShortcuts[i];
                    var oldAttributeValue = this.attributes[shortcuts[1]];
                    var newAttributeValue = shortcuts[0];
                    if (newAttributeValue != oldAttributeValue) {
                        attributesToSet[shortcuts[1]] = newAttributeValue;
                        if (oldAttributeValue) {
                            this.stopListening(oldAttributeValue, shortcuts[2]);
                        }
                        if (newAttributeValue) {
                            this.listenTo(newAttributeValue, shortcuts[2], shortcuts[3]);
                        }
                    }
                }
                this.set(attributesToSet);
            },


            __triggerChangeMethodOfDynamicDerivedConfigData: function() {
                this.dropCachedHash();
                this.trigger("change");
            },


            generateDynamicDerivedConfigData: function(entityConfig, configGrid) {
                var optionsOfThisDynamicDerivedConfigData = _.clone(this.__optionsOfDynamicDerivedConfigData);
                optionsOfThisDynamicDerivedConfigData.entityConfig = entityConfig;
                optionsOfThisDynamicDerivedConfigData.configGrid = configGrid;

                var dynamicDerivedConfigData = new RepresentationModule.DynamicDerivedConfigData({
                    collectionConfigOnTheLeft: null,
                    collectionConfigOnTheRight: null,
                    dynamicDefinitionForCollectionOnTheLeft: null,
                    dynamicDefinitionForCollectionOnTheRight: null
                }, optionsOfThisDynamicDerivedConfigData);

                dynamicDerivedConfigData.update = this.__updateMethodOfDynamicDerivedConfigData;
                dynamicDerivedConfigData._doUpdate = this.__doUpdateMethodOfDynamicDerivedConfigData;
                dynamicDerivedConfigData.triggerChange = this.__triggerChangeMethodOfDynamicDerivedConfigData;

                dynamicDerivedConfigData.listenTo(configGrid, "change_layout", dynamicDerivedConfigData.update);
                dynamicDerivedConfigData.update();

                return dynamicDerivedConfigData;
            },


            // =================================================================
            // dynamic derived vis instance data


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - base

            __optionsOfDynamicDerivedVisInstanceDataForBase: {
                attributesToExcludeFromHash: ["apiResponseOnTheLeft", "apiResponseOnTheRight"],
                customHashSuffixGenerator: function (attributes) {
                    if (attributes.apiResponseOnTheLeft) {
                        return JSON.stringify(attributes.apiResponseOnTheLeft.errors);
                    } else {
                        return typeof attributes.apiResponseOnTheLeft;
                    }
                    if (attributes.apiResponseOnTheRight) {
                        return JSON.stringify(attributes.apiResponseOnTheRight.errors);
                    } else {
                        return typeof attributes.apiResponseOnTheRight;
                    }
                }
            },


            __upateMethodOfDynamicDerivedVisInstanceDataForBase: function(force) {
                var visInstanceView = this.options.visInstanceView;
                var _this = this;
                _.each(["Right", "Left"], function(side) {
                    var dynamicDefinitionForCollection = visInstanceView.dynamicDerivedConfigDataForEntity.attributes["dynamicDefinitionForCollectionOnThe" + side];
                    if (!dynamicDefinitionForCollection) { // entity kind has changed (e.g. a grid was reset)
                        return;
                    }

                    var collectionId = dynamicDefinitionForCollection.attributes.id;
                    var requestParams = _.clone(visInstanceView.dynamicDerivedConfigDataForView.attributes.basePerspectiveRequestParams);

                    if (!requestParams || !collectionId) {
                        var attrs = {};
                        attrs["apiRequestURIOnThe" + side] = undefined;
                        attrs["apiRequestParamsHashOnThe" + side] = undefined;
                        attrs["apiResponseOnThe" + side] = undefined;
                        _this.set(attrs);
                        return;
                    }
                    requestParams.cid = collectionId;

                    var apiRequestParamsHash = JSON.stringify(requestParams);

                    if (!force && apiRequestParamsHash == _this.attributes["apiRequestParamsHashOnThe" + side]) {
                        return;
                    }

                    var apiRequestURI = App.DataModule.CliopatriaAPI.request("getCollectionPerspective", requestParams, function(data){
                        if (JSON.stringify(requestParams) != _this.attributes["apiRequestParamsHashOnThe" + side]) {
                            return;
                        }
                        var attrs = {};
                        attrs["apiRequestParamsHashOnThe" + side] = undefined;
                        attrs["apiResponseOnThe" + side] = data;
                        _this.set(attrs);
                    });

                    var attrs = {};
                    attrs["apiRequestURIOnThe" + side] = apiRequestURI;
                    attrs["apiRequestParamsHashOnThe" + side] = apiRequestParamsHash;
                    attrs["apiResponseOnThe" + side] = null;
                    _this.set(attrs);
                });
            },


            generateDynamicDerivedVisInstanceDataForBase: function(visInstanceView) {
                // An empty object if comparison is not supported
                var viewMaster = visInstanceView._cachedViewMaster;
                if (!viewMaster.options.visInstanceSupportedComparisonModes.length) {
                    return new RepresentationModule.DynamicDerivedVisInstanceData({});
                }

                var optionsForThisDynamicDerivedVisInstanceDataForBase = _.clone(this.__optionsOfDynamicDerivedVisInstanceDataForBase);
                optionsForThisDynamicDerivedVisInstanceDataForBase.visInstanceView = visInstanceView;

                var dynamicDerivedVisInstanceDataForBase = new RepresentationModule.DynamicDerivedVisInstanceData({
                    apiRequestURIOnTheLeft:         undefined,
                    apiRequestParamsHashOnTheLeft:  undefined,
                    apiResponseOnTheLeft:           undefined,
                    apiRequestURIOnTheRight:        undefined,
                    apiRequestParamsHashOnTheRight: undefined,
                    apiResponseOnTheRight:          undefined
                }, optionsForThisDynamicDerivedVisInstanceDataForBase);

                dynamicDerivedVisInstanceDataForBase.update = this.__upateMethodOfDynamicDerivedVisInstanceDataForBase;

                dynamicDerivedVisInstanceDataForBase.listenTo(visInstanceView.dynamicDerivedConfigDataForEntity, "change",  dynamicDerivedVisInstanceDataForBase.update);
                dynamicDerivedVisInstanceDataForBase.listenTo(visInstanceView.dynamicDerivedConfigDataForView, "change:basePerspectiveRequestParams", dynamicDerivedVisInstanceDataForBase.update);

                dynamicDerivedVisInstanceDataForBase.update();

                return dynamicDerivedVisInstanceDataForBase;
            },


            verifyAllDataForVisInstanceBase: function(visInstanceView) {
                this._verifyThatViewIsNotEmptyOrUnknown(visInstanceView);

//                if (visInstanceView.options.entityConfig.getParameterValue("kind")
//                    && visInstanceView.options.viewConfig.getParameterValue("kind") == "key-relative-chord-seq") {
//                    throw new RepresentationModule.Error({type: "drawing", derivedDataToUpdate: "base"});
//                   }

                var viewMaster = visInstanceView._cachedViewMaster;
                if (!viewMaster.options.canHaveBase) {
                    return;
                }
                var supportedComparisonModes = viewMaster.options.visInstanceSupportedComparisonModes;
                if (!supportedComparisonModes.length) {
                    throw new RepresentationModule.Error({type: "comparison_not-supported"});
                }
                if (!_.contains(supportedComparisonModes, viewMaster._getVisInstanceViewComparisonMode(visInstanceView))) {
                    throw new RepresentationModule.Error({type: "comparison_wrong-type", supportedTypes: supportedComparisonModes});
                }

                var attributesOfDerivedConfigDataForEntityOnTheLeft  = visInstanceView.dynamicDerivedConfigDataForEntity.attributes;
                var attributesOfDerivedConfigDataForEntityOnTheRight = visInstanceView.dynamicDerivedConfigDataForEntity.attributes;
                var dynamicDefinitionForCollectionOnTheLeft  = attributesOfDerivedConfigDataForEntityOnTheLeft .dynamicDefinitionForCollectionOnTheLeft;
                var dynamicDefinitionForCollectionOnTheRight = attributesOfDerivedConfigDataForEntityOnTheRight.dynamicDefinitionForCollectionOnTheRight;
                var attributesOfCollectionOnTheLeft  = dynamicDefinitionForCollectionOnTheLeft  ? dynamicDefinitionForCollectionOnTheLeft.attributes  : {};
                var attributesOfCollectionOnTheRight = dynamicDefinitionForCollectionOnTheRight ? dynamicDefinitionForCollectionOnTheRight.attributes : {};

                if (attributesOfCollectionOnTheLeft.id === null || attributesOfCollectionOnTheRight.id === null) {
                    throw new RepresentationModule.Error({type: "data-preparing_entity-derived"});
                }
                if (attributesOfCollectionOnTheLeft.id === false || attributesOfCollectionOnTheRight.id === false) {
                    var apiErrorsOnTheLeft  = attributesOfCollectionOnTheLeft .errors || [];
                    var apiErrorsOnTheRight = attributesOfCollectionOnTheRight.errors || [];
                    apiErrors = apiErrorsOnTheLeft.concat(apiErrorsOnTheRight);
                    throw new RepresentationModule.Error({type: "api-error_entity-derived", apiErrors: apiErrors, coverTapAction: this.__coverTapActionThatUpdatesDynamicDerivedData, derivedDataToUpdate: "entity"});
                }
                if ((attributesOfCollectionOnTheLeft .id === "" || (attributesOfCollectionOnTheLeft .hasOwnProperty("id") && attributesOfCollectionOnTheLeft .id === undefined))
                 || (attributesOfCollectionOnTheRight.id === "" || (attributesOfCollectionOnTheRight.hasOwnProperty("id") && attributesOfCollectionOnTheRight.id === undefined))) {
                    throw new RepresentationModule.Error({type: "collection_no-recordings"});
                }
                if (attributesOfCollectionOnTheLeft.id === undefined || attributesOfCollectionOnTheRight.id === undefined) {
                    throw new RepresentationModule.Error({type: "pair_incomplete"});
                }

                var attribytesOfDerivedVisInstanceDataForBase = visInstanceView.dynamicDerivedVisInstanceDataForBase.attributes;
                if (!attribytesOfDerivedVisInstanceDataForBase.apiResponseOnTheLeft || !attribytesOfDerivedVisInstanceDataForBase.apiResponseOnTheRight) {
                    throw new RepresentationModule.Error({type: "data-preparing_base"});
                }
                if (attribytesOfDerivedVisInstanceDataForBase.apiResponseOnTheLeft.errors || attribytesOfDerivedVisInstanceDataForBase.apiResponseOnTheRight.errors) {
                    var apiErrorsOnTheLeft  = attribytesOfDerivedVisInstanceDataForBase.apiResponseOnTheLeft .errors || [];
                    var apiErrorsOnTheRight = attribytesOfDerivedVisInstanceDataForBase.apiResponseOnTheRight.errors || [];
                    var apiErrors = apiErrorsOnTheLeft.concat(apiErrorsOnTheRight);

                    if (apiErrors[0]) {
                        var error0 = apiErrors[0];
                        if (((error0.code == 11 || error0.code == 12) && !apiErrors[1]) || (apiErrors[1] && (apiErrors[1].code == 11 || apiErrors[1].code == 12))) {
                            throw new RepresentationModule.Error({type: "api-message_progress_base", apiErrors: apiErrors, coverTapAction: this.__coverTapActionThatUpdatesDynamicDerivedData, derivedDataToUpdate: "base"});

                        // FIXME errors like this should probably go to Master.view.xxx
                        } else if ((error0.code == 20 && !apiErrors[1]) || (apiErrors[1] && (apiErrors[1].code == 20))) {
                            return;
                        }

                    }

                    throw new RepresentationModule.Error({type: "api-error_base", apiErrors: apiErrors, coverTapAction: this.__coverTapActionThatUpdatesDynamicDerivedData, derivedDataToUpdate: "base"});
                }
            },
        });
    });
}, Logger);
