/**
 * Changes the default functionality of _.uniqueId()
 * 
 * Adds a new function _.markUniqueIdAsAlreadyUsed
 * 
 * Quicker alternative to
 *  _.isObject(serializedAttributes) && !_.isArray(serializedAttributes)  && !_.isFunction(serializedAttributes)
 *  
 * @memberOf _
 */
var toString = Object.prototype.toString;
if (_) {
    var idCounter = 0;
    var alreadyUsedUniqueIds = {};
    _.mixin({
        uniqueId: function(prefix) {
            while (true) {
                var id = ++idCounter + '';
                var uniqueId = prefix ? prefix + id : id;
                if (!alreadyUsedUniqueIds[uniqueId]) {
                    return uniqueId;
                }
            }
        },
        
        markUniqueIdAsAlreadyUsed: function(uniqueId) {
            alreadyUsedUniqueIds[uniqueId] = true;
        }
    });
} else {
    console.error("Can't register _.uniqueId and _.markUniqueIdAsAlreadyUsed without underscore.js (global variable '_')");
}
