"use strict";

App.module("ContextModule", function(ContextModule, App, Backbone, Marionette, $, _, Logger) {

    // Define private variables
    var logger = null;

    ContextModule.addInitializer(function(options){
        
//        logger = Logger.get("ContextModule.StateBookmark");
//        logger.setLevel(Logger.DEBUG);
        
        /**
         * StateBookmark contains a named serialized state
         */
        ContextModule.StateBookmark = Backbone.Model.extend({
            defaults: {
                name: null,
                time: null,
                serializedState: null,
                comment: null,
            },

            /**
             * @memberOf App.ContextModule.StateBookmark
             */
            initialize: function() {
            },

            serialize: function() {
                logger.debug("method called: State::serialize");

                var result = _.clone(this.attributes);

                return result;
            },
            
            unserialize: function(serializedAttributes) {
                this.clear({silent: true}).set(serializedAttributes);
            },
        });

    });
}, Logger);
